% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_corpus_LMRDsample}
\alias{data_corpus_LMRDsample}
\title{Sample from Large Movie Review Dataset (Maas et al. 2011)}
\format{
The corpus docvars consist of:
\describe{
\item{docnumber}{serial (within set and polarity) document number}
\item{rating}{user-assigned movie rating on a 1-10 point integer scale}
\item{polarity}{either \code{neg} or \code{pos} to indicate whether the
movie review was negative or positive.  See Maas et al (2011) for the
cut-off values that governed this assignment.}
}
}
\source{
\url{http://ai.stanford.edu/~amaas/data/sentiment/}
}
\usage{
data_corpus_LMRDsample
}
\description{
A sample of 100 positive and 100 negative reviews from the Maas et al. (2011)
dataset for sentiment classification.  The original dataset contains 50,000
highly polar movie reviews.
}
\examples{
if (requireNamespace("quanteda", quietly = TRUE)) {
  # Inspect the corpus
  summary(data_corpus_LMRDsample)

  # Sample a few reviews
  head(data_corpus_LMRDsample, 3)
}
}
\references{
Andrew L. Maas, Raymond E. Daly, Peter T. Pham, Dan Huang, Andrew
Y. Ng, and Christopher Potts. (2011). "\href{http://ai.stanford.edu/~amaas/papers/wvSent_acl2011.pdf}{Learning Word Vectors for Sentiment Analysis}". The
49th Annual Meeting of the Association for Computational Linguistics (ACL
2011).
}
\seealso{
\link{data_codebook_sentiment} for an example codebook and usage with this corpus
}
\keyword{data}
