% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{businessDaysBetween}
\alias{businessDaysBetween}
\title{Compute number of business dates between calendar dates}
\usage{
businessDaysBetween(from, to, includeFirst = TRUE, includeLast = FALSE,
  xp = NULL)
}
\arguments{
\item{from}{A Date vector with interval start dates}

\item{to}{A Date vector with interval end dates}

\item{includeFirst}{A boolean indicating if the start date is included, default
is \sQuote{TRUE}}

\item{includeLast}{A boolean indicating if the end date is included, default
is \sQuote{FALSE}}

\item{xp}{An optional calendar object, if missing the default instance is used}
}
\value{
A numeric vector with the number of business dates between the
corresponding date pair
}
\description{
Compute the number of business days between dates
}
\details{
This function takes two vectors of start and end dates and returns another
vector of the number of business days between each corresponding date pair
according to the active calendar.
}
\examples{
businessDaysBetween(Sys.Date() + 0:6, Sys.Date() + 3 + 0:6)
}
