% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_functions.R
\name{EM_calibration_gaussian_memory}
\alias{EM_calibration_gaussian_memory}
\title{EM calibration in the case of the Gaussian copula (unsigned) with memory management}
\usage{
EM_calibration_gaussian_memory(
  Logf0Mat,
  Logf1Mat,
  F0Mat,
  F1Mat,
  Prior.init,
  R.init,
  Hconfig,
  Precision = 1e-06,
  threads_nb
)
}
\arguments{
\item{Logf0Mat}{a matrix containing the \eqn{\log(f_0(x^i_q))}}

\item{Logf1Mat}{a matrix containing the \eqn{\log(f_1(x^i_q))}}

\item{F0Mat}{a matrix containing the evaluation of the marginal cdf under \eqn{H_0} at each items, each column corresponding to a p-value serie.}

\item{F1Mat}{a matrix containing the evaluation of the marginal cdf under \eqn{H_1} at each items, each column corresponding to a p-value serie.}

\item{Prior.init}{the initialization of prior probabilities for each of the H-configurations.}

\item{R.init}{the initialization of the correlation matrix of the gaussian copula parameter.}

\item{Hconfig}{A list of all possible combination of \eqn{H_0} and \eqn{H_1} hypotheses generated by the \link[=GetHconfig]{GetHconfig()} function.}

\item{Precision}{Precision for the stop criterion. (Default is 1e-6)}

\item{threads_nb}{The number of threads to use.}
}
\value{
A list with the following elements:
\tabular{ll}{
\code{priorHconfig} \tab vector of estimated prior probabilities
for each of the H-configurations.\cr
\code{Rcopula} \tab the estimated correlation matrix of the Gaussian copula.
}
}
\description{
EM calibration in the case of the Gaussian copula (unsigned) with memory management
}
