% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwrcontrast.r
\name{pwrcontrast}
\alias{pwrcontrast}
\title{Power Analysis for Planned Contrast in Between- or Within-Factor ANOVA}
\usage{
pwrcontrast(
  weight = NULL,
  paired = FALSE,
  n_total = NULL,
  cohensf = NULL,
  peta2 = NULL,
  alpha = NULL,
  power = NULL,
  nlim = c(2, 10000)
)
}
\arguments{
\item{weight}{Numeric vector (length \eqn{K \ge 2}). Contrast weights whose sum must be zero.}

\item{paired}{Logical. \code{FALSE} for between-subjects (default), \code{TRUE} for paired/repeated-measures.}

\item{n_total}{Integer or integer vector. Total sample size(s). If \code{NULL}, the function solves for \code{n_total}.}

\item{cohensf}{Numeric (non-negative). Cohen's \eqn{f}. If \code{NULL}, it is derived from \code{peta2} when available.}

\item{peta2}{Numeric in \eqn{(0,1)}. Partial eta squared. If \code{NULL}, it is derived from \code{cohensf} when available.}

\item{alpha}{Numeric in \eqn{(0,1)}. If \code{NULL}, it is solved for.}

\item{power}{Numeric in \eqn{(0,1)}. If \code{NULL}, it is computed; if \code{n_total} is \code{NULL}, \code{n_total} is solved to achieve this power.}

\item{nlim}{Integer length-2. Search range of total \code{n} when solving sample size.}
}
\value{
A one-row data frame with class:
\itemize{
\item \code{"cal_power"} when power is calculated given \code{n_total}, \code{alpha}, and effect size;
\item \code{"cal_n"} when \code{n_total} is solved;
\item \code{"cal_alpha"} when \code{alpha} is solved;
\item \code{"cal_es"} when minimal detectable effect sizes are solved.
}
Columns: \code{term} (always \code{"contrast"}), \code{weight} (comma-separated string),
\code{df_num}, \code{df_denom}, \code{n_total}, \code{alpha}, \code{power},
\code{cohensf}, \code{peta2}, \code{F_critical}, \code{ncp}.
}
\description{
Computes power, required total sample size, alpha, or minimal detectable
effect size for a \strong{single planned contrast} (1 df) in between-participants
or paired/repeated-measures settings.
}
\details{
For a contrast with weights \eqn{w_1, \dots, w_K} that sum to zero,
the numerator df is 1. The denominator df is \eqn{n - K} for
between-subjects (unpaired) designs and \eqn{(n - 1)(K - 1)} for
paired/repeated-measures designs. Power uses the noncentral \emph{F}-with
\eqn{\lambda = f^2 \cdot n_{\mathrm{total}}}.

\itemize{
\item Contrast weights (\code{weight}) are not centered internally; only the
zero-sum condition is enforced (up to numerical tolerance).
\item When \code{paired = FALSE}, the total sample size \code{n_total} must be
a multiple of the number of contrast groups \eqn{K}.
\item Exactly one of \code{n_total}, an effect-size specification
(\code{cohensf}/\code{peta2}), \code{alpha}, or \code{power} must be
\code{NULL}; that quantity is then solved.
\item Critical values are computed from the central \emph{F}-distribution; power
is based on the noncentral \emph{F}-distribution with noncentrality parameter
\eqn{\lambda = f^2 \cdot n_{\mathrm{total}}}.
\item Effect-size inputs can be given as Cohen’s \eqn{f} or partial eta-squared
\eqn{\eta_p^2} (internally converted via
\eqn{f = \sqrt{\eta_p^2/(1-\eta_p^2)}}). If both are \code{NULL}, the
minimal detectable effect size is solved for given \code{n_total},
\code{alpha}, and \code{power}.
}
}
\examples{
# Two-group contrast (1, -1), between-subjects: compute power
pwrcontrast(weight = c(1, -1), paired = FALSE,
            n_total = 40, cohensf = 0.25, alpha = 0.05)

# Four-level contrast (e.g., Helmert-like), solve required N for target power
pwrcontrast(weight = c(3, -1, -1, -1), paired = FALSE,
            n_total = NULL, peta2 = 0.06, alpha = 0.05, power = 0.80)

# Paired contrast across K=3 conditions
pwrcontrast(weight = c(1, 0, -1), paired = TRUE,
            n_total = NULL, cohensf = 0.2, alpha = 0.05, power = 0.9)

}
\references{
Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.).
Hillsdale, NJ: Lawrence Erlbaum Associates.
}
