% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_designs.R
\name{designCRD}
\alias{designCRD}
\alias{design.CRD}
\alias{design.RCBD}
\alias{design.LSD}
\alias{design.COD}
\alias{design.SPD}
\alias{designRCBD}
\alias{designLSD}
\alias{designCOD}
\alias{designSPD}
\title{Creation of Standard Experimental Designs}
\usage{
designCRD(
  treatments,
  label,
  replicates,
  formula,
  beta = NULL,
  means = NULL,
  sigma2,
  template = FALSE,
  REML = TRUE
)

designRCBD(
  treatments,
  label,
  blocks,
  formula,
  beta = NULL,
  means = NULL,
  vcomp,
  sigma2,
  template = FALSE,
  REML = TRUE
)

designLSD(
  treatments,
  label,
  squares = 1,
  reuse = c("row", "col", "none"),
  formula,
  beta = NULL,
  means = NULL,
  vcomp,
  sigma2,
  template = FALSE,
  REML = TRUE
)

designCOD(
  treatments,
  label,
  squares = 1,
  formula,
  beta = NULL,
  means = NULL,
  vcomp,
  sigma2,
  template = FALSE,
  REML = TRUE
)

designSPD(
  trt.main,
  trt.sub,
  label,
  replicates,
  formula,
  beta = NULL,
  means = NULL,
  vcomp,
  sigma2,
  template = FALSE,
  REML = TRUE
)
}
\arguments{
\item{treatments}{An integer vector where each element represents the number of levels
of the corresponding treatment factor. A single integer (e.g., \code{treatments = n})
specifies one treatment factor with \code{n} levels. When multiple factors are provided,
they are arranged in a factorial treatment factor design. For example,
\code{treatments = c(2, 3)} creates a 2x3 factorial design with the first factor having 2 levels
and the second factor having 3 levels.}

\item{label}{Optional. A list of character vectors, each corresponding to a treatment factor.
The name of each vector specifies the factor's name, and its elements provide the labels for that factor's levels.
If no labels are provided, default labels will be used. For a single treatment factor, the default is
\code{list(trt = c("1", "2", ...))}, and for two treatment factors, the default is
\code{list(facA = c("1", "2", ...), facB = c("1", "2", ...))}.
For split-plot designs, the defaults are similar but include the ".main" and ".sub" suffixes for main plot and subplot factors.
For example:
\code{list(trt.main = c("1", "2", ...), trt.sub = c("1", "2", ...))} and
\code{list(facA.main = c("1", "2", ...), facB.main = c("1", "2", ...),
      facA.sub = c("1", "2", ...), facB.sub = c("1", "2", ...))}.
Label sets should be arranged so that the main plot factors come first, followed by the subplot factors.}

\item{replicates}{The number of experimental units per treatment in a completely
randomized design or the number of experimental units (main plots) per treatment
of main plot factors.}

\item{formula}{A right-hand-side \link{formula} specifying the model for testing treatment effects,
with terms on the right of \link{~} , following \link[lme4:lmer]{lme4::lmer} syntax for random effects.
If not specified, a default formula with main effects and all interactions is used internally.}

\item{beta}{One of the optional inputs for fixed effects.
A vector of model coefficients where factor variable coefficients correspond
to dummy variables created using treatment contrast (\link[stats:contrast]{stats::contr.treatment}).}

\item{means}{One of the optional inputs for fixed effects.
A vector of marginal or conditioned means (if factors have interactions).
Regression coefficients are required for numerical variables.
Either \code{beta} or \code{means} must be provided, and their values must strictly follow a specific order.
A template can be created to indicate the required input values and their order.
See \link{mkdesign} for more information.}

\item{sigma2}{error variance.}

\item{template}{Default is \code{FALSE}.
If \code{TRUE}, a template for \code{beta}, \code{means}, and \code{vcomp} is generated to indicate the required input order.}

\item{REML}{Specifies whether to use REML or ML information matrix. Default is \code{TRUE} (REML).}

\item{blocks}{The number of blocks.}

\item{vcomp}{A vector of variance-covariance components for random effects, if present.
The values must follow a strict order. See \link{mkdesign}.}

\item{squares}{The number of replicated squares. By default, 1, i.e., no
replicated squares.}

\item{reuse}{A character string specifying how to replicate squares when
there are multiple squares. Options are: "row" for reusing row blocks, "col"
for reusing column blocks, or "none" for reusing neither row nor column blocks
to replicate a single square.}

\item{trt.main}{An integer-valued vector specifying the treatment structure at
main plot level for a split plot design, similar to \code{treatments}.}

\item{trt.sub}{An integer-valued vector specifying the treatment structure at
sub plot level for a split plot design, similar to \code{treatments}.}
}
\value{
A list object containing all essential components for power calculation.
This includes:
\itemize{
\item Structural components (deStruct): including the data frame, design matrices
for fixed and random effects, variance-covariance matrices for random effects
and residuals, etc.
\item Internally calculated higher-level parameters (deParam), including variance-covariance
matrix of beta coefficients (vcov_beta), variance-covariance matrix of variance parameters (vcov_varpar),
gradient matrices (Jac_list), etc.
}
}
\description{
These functions facilitate the creation of standard experimental designs
commonly used in agricultural studies for power analysis. Unlike \link{mkdesign}
which requires a pre-existing data frame, these functions allow users to
directly specify key design characteristics to generate experimental layouts.
Quantitative parameters describing fixed and random effects remain consistent
with those in \link{mkdesign}.
}
\details{
Each function creates a standard design as described below:
\describe{
\item{\code{designCRD}}{Completely Randomized Design.
By default, the model formula is \code{~ trt} for one factor and
\code{~ facA*facB} for two factors, unless explicitly specified. If the
\code{label} argument is provided, the formula is automatically updated with the
specified treatment factor names.}
\item{\code{designRCBD}}{Randomized Complete Block Design.
Experimental units are grouped into blocks, with each treatment appearing
\strong{exactly} once per block (i.e., no replicates per treatment within a block).
The default model formula is \code{~ trt + (1|block)} for one factor and
\code{~ facA*facB + (1|block)} for two factors. If \code{label} is provided, the
fixed effect parts of the formula are automatically updated with the specified
names. The block factor is named "block" and not changeable.}
\item{\code{designLSD}}{Latin Square Design.
The default formula is \code{~ trt + (1|row) + (1|col)} for one factor and
\code{~ facA*facB + (1|row) + (1|col)} for two factors. If \code{label} is provided,
the fixed effect parts of the formula are automatically updated with the specified
names. The names of row ("row") and column ("col") block factors are not changeable.}
\item{\code{designCOD}}{Crossover Design, which is a special case of LSD
with time periods and individuals as blocks. Period blocks are reused when
replicating squares.
The default formula is \code{~ trt + (1|subject) + (1|period)} for one factor
and \code{~ facA*facB + (1|subject) + (1|period)} for two factors. If \code{label}
is provided, the fixed effect parts of the formula are automatically updated
with the specified names. Note that "subject" and "period" are the names for
the two blocking factors and cannot be changed.}
\item{\code{designSPD}}{Split Plot Design.
The default formula includes the main effects of all treatment factors at
both the main and sub-plot levels, their interactions, and the random effects
of main plots: \code{~ . + (1|mainplot)}. If \code{label} is provided, the fixed
effect parts of the formula are automatically updated with the specified names.
The experimental unit at the main plot level (i.e., the block factor at the
subplot level) is always named as "mainplot".}}
}
\examples{
# Evaluate the power of a CRD with one treatment factor
## Create a design object
crd <- designCRD(
  treatments = 4, # 4 levels of one treatment factor
  replicates = 12, # 12 units per level, 48 units totally
  means = c(30, 28, 33, 35), # means of the 4 levels
  sigma2 = 10 # error variance
)

## power of omnibus test
pwr.anova(crd)

## power of contrast
pwr.contrast(crd, which = "trt", contrast = "pairwise") # pairwise comparisons
pwr.contrast(crd, which = "trt", contrast = "poly") # polynomial contrasts

# More examples are available in `vignette("pwr4exp")`
# and on https://an-ethz.github.io/pwr4exp/

}
\seealso{
\link{mkdesign}, \link{pwr.anova}, \link{pwr.contrast}
}
