% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_rollcall.R
\name{preprocess_rollcall}
\alias{preprocess_rollcall}
\title{Preprocess Roll Call Data}
\usage{
preprocess_rollcall(
  x,
  data_preprocess = list(leg_rm = NULL, combine_leg_index = NULL, combine_leg_party =
    NULL, lop_leg = 0.6, lop_issue = 0)
)
}
\arguments{
\item{x}{A roll call object.}

\item{data_preprocess}{A list of parameters for preprocessing data:
\itemize{
  \item `leg_rm` (default = NULL): A vector of indices specifying legislators to be removed.
  \item `combine_leg_index` (default = NULL): A list of vectors where each vector specifies the indices of legislators to be combined.
  \item `combine_leg_party` (default = NULL): A vector specifying the party affiliations for combined legislators.
  \item `lop_leg` (default = 0.6): A threshold indicating the maximum allowable proportion of missing votes for each legislator. Legislators with a proportion of missing votes greater than this value are removed.
  \item `lop_issue` (default = 0): A threshold for the proportion of non-missing votes on the minority side. Voting issues with a minority proportion lower than this value are excluded.
}}
}
\value{
A roll call object that has been processed.
}
\description{
This function is used to preprocess roll call data for analysis.
It allows users to remove legislators, combine legislators with specified indices, exclude lopsided votes based on minority voting proportions, and filter out legislators with excessive missing votes.
}
\examples{
data(h116)
h116.c = preprocess_rollcall(h116)
}
