% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.element.count.R
\name{build.element.count}
\alias{build.element.count}
\title{build.element.count}
\usage{
build.element.count(
  pc.directory = NULL,
  pubchem.bio.object = NULL,
  remove.homonuclear.molecules = TRUE,
  remove.inorganics = TRUE
)
}
\arguments{
\item{pc.directory}{directory from which to load pubchem .Rdata files}

\item{pubchem.bio.object}{R data.table, generally produced by build.pubchem.bio; preferably, define pc.directory}

\item{remove.homonuclear.molecules}{logical. default = TRUE.  should molecules with one element (or fewer) be removed?}

\item{remove.inorganics}{logical. default = TRUE.  Should inorganic molecules (no carbon) be removed?}
}
\value{
a data.table, same as input, except inorganics will have been removed.
}
\description{
takes as input an pubchem.bio data.table (generally produced by 'build.pubchem.bio' or 'build.taxon.metabolome') and removes inorganic compounds (those without any carbon).
}
\details{
utilizes downloaded and properly formatted local pubchem data created by 'build.pubchem.bio' function, removes inorganic compounds. note that for any formula which have charge noted '+' or '-', the charge is removed for tabulation of the element count.
}
\author{
Corey Broeckling
}
