% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt_optim_entropy.R
\name{pt_optim_entropy}
\alias{pt_optim_entropy}
\title{Maximum Entropy Approach}
\usage{
pt_optim_entropy(
  optim = optim,
  mono = mono,
  v = v,
  variance = variance,
  lb = p_lb,
  ub = p_ub,
  ndigits
)
}
\arguments{
\item{optim}{optimization parameter (1=default, 2-4=further test 
implementations)}

\item{mono}{(logical) monotony parameter}

\item{v}{(integer) vector with perturbation values (i.e. deviations to the 
original frequency)}

\item{variance}{(numeric) variance parameter}

\item{lb}{(integer) vector with lower bounds of the controls}

\item{ub}{(integer) vector with upper bounds of the controls}

\item{ndigits}{(integer) number of digits}
}
\value{
The return value contains a list with two elements:
\describe{
 \item{"\code{result}"}{   optimal value of the controls}
 \item{"\code{iter}"  }{   number of iterations that were executed}
}
}
\description{
Function to solve the non-linear optimization problem used 
within \code{\link{ptable}()}.
}
\details{
The main parameter is `optim`: In `optim=1 to 3` the variance is 
stated as inequality constraint and in `optim=4` the variance condition is 
stated as equality constraint.
}
\seealso{
Giessing, S. (2016), 'Computational Issues in the Design of 
Transition Probabilities and Disclosure Risk Estimation for Additive Noise'. 
In: Domingo-Ferrer, J. and Pejic-Bach, M. (Eds.), Privacy in Statistical 
Databases, pp. 237-251, Springer International Publishing, LNCS, vol. 9867.

Fraser, B. and Wooton, J.: A proposed method for confidentialising 
tabular output to protect against differencing. In: Monographs of Official 
Statistics. Work session on Statistical Data Confidentiality, 
Eurostat-Office for Official Publications of the European Communities, 
Luxembourg, 2006, pp. 299-302
}
\author{
Tobias Enderle, Sarah Giessing, Jonas Peter
}
\keyword{optimization}
