\name{setestimator}
\alias{setestimator}
\alias{setoptimizer}
\alias{usecpp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Convenience functions
}
\description{
These functions can be used to change some estimator options.
}
\usage{
setestimator(x, estimator)

setoptimizer(x, optimizer = c("default", "nlminb", "ucminf",
                 "nloptr_TNEWTON", "LBFGS++"), optim.args)


usecpp(x, use = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
A \code{psychonetrics} model.
}
  \item{estimator}{
A string indicating the estimator to be used
}
  \item{optimizer}{
The optimizer to be used. The following optimizers are available:

\bold{R-based optimizers:}
\describe{
  \item{\code{"nlminb"}}{Port trust-region Newton-like optimizer from base R. Uses analytic gradients and a trust-region method that adaptively controls step sizes, making it very stable for SEM problems. This is the default and recommended optimizer for most models.}
  \item{\code{"ucminf"}}{Unconstrained minimization using a quasi-Newton method (via the \code{optimr} package). Does not support box constraints. Fast for unconstrained problems.}
}

\bold{C++ based optimizer:}
\describe{
  \item{\code{"LBFGS++"}}{L-BFGS-B optimizer from the LBFGSpp library (Yixuan Qiu). This is a pure C++ implementation that computes the objective function and gradient in a single combined call, avoiding redundant computation via internal caching. Supports box constraints. Recommended when speed is important.}
}

\bold{NLopt-based optimizer (via nloptr):}
\describe{
  \item{\code{"nloptr_TNEWTON"}}{Preconditioned truncated Newton with restarts from the NLopt library (via the \code{nloptr} package). Uses the \code{NLOPT_LD_TNEWTON_PRECOND_RESTART} algorithm, which builds a local quadratic model of the objective and solves the Newton system approximately using a preconditioned conjugate-gradient method. Supports box constraints and uses analytic gradients. Can handle large parameter spaces efficiently. See Dembo & Steihaug (1982) for the underlying method.}
}

Defaults to \code{"nlminb"}.
}
\item{use}{
Logical indicating if C++ should be used (currently only used in FIML)
}
\item{optim.args}{List of arguments to sent to the optimizer.}
}
\value{
An object of the class psychonetrics (\link{psychonetrics-class})
}
\details{The default optimizer is nlminb with the following arguments:
\itemize{
\item eval.max=20000L
\item iter.max=10000L
\item trace=0L
\item abs.tol=sqrt(.Machine$double.eps)
\item rel.tol=sqrt(.Machine$double.eps)
\item step.min=1.0
\item step.max=1.0
\item x.tol=1.5e-8
\item xf.tol=2.2e-14
}

}
\author{
Sacha Epskamp
}

