% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_infer.R
\name{psrwe_infer}
\alias{psrwe_infer}
\title{Inference for the PS-Integrated Estimation}
\usage{
psrwe_infer(
  dta_psrst,
  alternative = c("less", "greater", "two_sided"),
  mu = 0,
  method_pval = c("wald", "score", "score_weighted"),
  ...
)
}
\arguments{
\item{dta_psrst}{A returned object with class \code{PSRWE_EST}}

\item{alternative}{A character string for the alternative hypothesis that
must be one of \code{"less"} (default), \code{"greater"}, or
\code{"two_sided"} (for log-rank and RMST only)}

\item{mu}{A number indicating the true value of the parameter of interest
(or the difference in means for two arms),
\code{mu = 0} when the test is log-rank or RMST}

\item{method_pval}{A method name for p-value (default wald),
no effect on Bayesian methods, and
\code{method = "score"} only is for binary outcomes in
single arm studes (i.e., comparing with a PG set by \code{mu})}

\item{...}{Other options}
}
\value{
A list with class name \code{PSRWE_EST}.
}
\description{
Inference for the PS-integrated approach.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
ps_rst <- psrwe_compl(ps_borrow, v_outcome = "Y_Con")
rst <- psrwe_infer(ps_rst)
rst

}
