% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-validate.R
\name{cal_validate_beta}
\alias{cal_validate_beta}
\alias{cal_validate_beta.resample_results}
\alias{cal_validate_beta.rset}
\alias{cal_validate_beta.tune_results}
\title{Measure performance with and without using Beta calibration}
\usage{
cal_validate_beta(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred_"),
  metrics = NULL,
  save_pred = FALSE,
  ...
)

\method{cal_validate_beta}{resample_results}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred_"),
  metrics = NULL,
  save_pred = FALSE,
  ...
)

\method{cal_validate_beta}{rset}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred_"),
  metrics = NULL,
  save_pred = FALSE,
  ...
)

\method{cal_validate_beta}{tune_results}(
  .data,
  truth = NULL,
  estimate = NULL,
  metrics = NULL,
  save_pred = FALSE,
  ...
)
}
\arguments{
\item{.data}{An \code{rset} object or the results of \code{\link[tune:fit_resamples]{tune::fit_resamples()}} with
a \code{.predictions} column.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should be an unquoted column name.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities. It
defaults to the prefix used by tidymodels (\code{.pred_}). The order of the
identifiers will be considered the same as the order of the levels of the
\code{truth} variable.}

\item{metrics}{A set of metrics passed created via \code{\link[yardstick:metric_set]{yardstick::metric_set()}}}

\item{save_pred}{Indicates whether to a column of post-calibration predictions.}

\item{...}{Options to pass to \code{\link[=cal_estimate_beta]{cal_estimate_beta()}}, such as the
\code{shape_params} and \code{location_params} arguments.}
}
\value{
The original object with a \code{.metrics_cal} column and, optionally,
an additional \code{.predictions_cal} column. The class \code{cal_rset} is also added.
}
\description{
This function uses resampling to measure the effect of calibrating predicted
values.
}
\details{
These functions are designed to calculate performance with and without
calibration. They use resampling to measure out-of-sample effectiveness.
There are two ways to pass the data in:
\itemize{
\item If you have a data frame of predictions, an \code{rset} object can be created
via \pkg{rsample} functions. See the example below.
\item If you have already made a resampling object from the original data and
used it with \code{\link[tune:fit_resamples]{tune::fit_resamples()}}, you can pass that object to the
calibration function and it will use the same resampling scheme. If a
different resampling scheme should be used, run
\code{\link[tune:collect_predictions]{tune::collect_predictions()}} on the object and use the process in the
previous bullet point.
}

Please note that these functions do not apply to \code{tune_result} objects. The
notion of "validation" implies that the tuning parameter selection has been
resolved.

\code{collect_predictions()} can be used to aggregate the metrics for analysis.
}
\section{Performance Metrics}{


By default, the average of the Brier scores is returned. Any appropriate
\code{\link[yardstick:metric_set]{yardstick::metric_set()}} can be used. The validation function compares the
average of the metrics before, and after the calibration.
}

\examples{

library(dplyr)

if (rlang::is_installed("betacal")) {
  segment_logistic |>
    rsample::vfold_cv() |>
    cal_validate_beta(Class)
}
}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_estimate_beta]{cal_estimate_beta()}}
}
