% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{posterior_summary}
\alias{posterior_summary}
\title{Compute Posterior Summaries}
\usage{
posterior_summary(posterior, n_samples = 10000, prob = 0.95)
}
\arguments{
\item{posterior}{Posterior object from posterior_univariate() or
posterior_multivariate()}

\item{n_samples}{Number of samples to draw (default: 10000)}

\item{prob}{Probability for credible intervals (default: 0.95)}
}
\value{
A list with posterior summaries
}
\description{
Provides comprehensive posterior summary statistics.
}
\examples{
set.seed(123)
historical <- rnorm(50, mean = 10, sd = 2)
current <- rnorm(30, mean = 10.5, sd = 2)

pp <- powerprior_univariate(historical, a0 = 0.5)
posterior <- posterior_univariate(pp, current)
summary <- posterior_summary(posterior)
print(summary)

}
