% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoverRelation.R
\name{CoverRelation}
\alias{CoverRelation}
\title{Computing the cover relation of a poset.}
\usage{
CoverRelation(poset)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
A two-column matrix  \eqn{M} of character strings (element \eqn{M[i,2]} covers element \eqn{M[i,1]}).
}
\description{
Computes the cover relation of the input poset.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

M <- CoverRelation(pos)

}
