% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pollen_season.R
\name{pollen_season}
\alias{pollen_season}
\title{A Pollen Season Function}
\usage{
pollen_season(value, date, method, threshold = NULL)
}
\arguments{
\item{value}{pollen concentration values}

\item{date}{dates}

\item{method}{the pollen season method - "90", "95", "98", "Mesa", "Jager", "Lejoly", or "Driessen"}

\item{threshold}{a threshold value used for the "Driessen" method}
}
\value{
a data.frame object with year, date of pollen season start and date of pollen season end
}
\description{
This function calculates the start and the end of pollen season for each year
}
\examples{

data(pollen_count)
df <- subset(pollen_count, site=='Oz')
pollen_season(value=df$birch, date=df$date, method="95")

df2 <- subset(pollen_count, site=='Atlantis')
pollen_season(value=df2$alder, date=df2$date, method="95")

library('purrr')
pollen_count \%>\% split(., .$site) \%>\%
                 map_df(~pollen_season(value=.$hazel, date=.$date, method="95"), .id="site")

}
\references{
Nilsson S. and Persson S.: 1981, Tree pollen spectra in the Stockholm region (Sweden) 1973-1980, Grana 20, 179-182.

Andersen T.B.: 1991, A model to predict the beginning of the pollen season, Grana 30, 269-275.

Torben B.A.: 1991, A model to predict the beginning of the pollen season, Grana 30, 269-275.

Galan C., Emberlin J., Dominguez E., Bryant R.H. and Villamandos F.: 1995, A comparative analysis of daily variations in the Gramineae pollen counts at Cordoba, Spain and London, UK, Grana 34, 189-198.

Sanchez-Mesa J.A., Smith M., Emberlin J., Allitt U., Caulton E. and Galan C.: 2003, Characteristics of grass pollen seasons in areas of southern Spain and the United Kingdom, Aerobiologia 19, 243-250.

Jager S., Nilsson S., Berggren B., Pessi A.M., Helander M. and Ramfjord H.: 1996, Trends of some airborne tree pollen in the Nordic countries and Austria, 1980-1993. A comparison between Stockholm, Trondheim, Turku and Vienna, Grana 35, 171-178.

Lejoly-Gabriel and Leuschner: 1983, Comparison of air-borne pollen at Louvain-la-Neuve (Belgium) and Basel (Switzerland) during 1979 and 1980, Grana 22, 59-64.

Driessen M. N. B. M., Van Herpen R. M. A. and Smithuis, L. O. M. J.: 1990, Prediction of the start of the grass pollen season for the southern part of the Netherlands, Grana, 29(1), 79-86.
}
