% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blrt.R
\name{blrt}
\alias{blrt}
\title{Bootstrap likelihood ratio test (non-regression only)}
\usage{
blrt(
  model_null,
  model_alt,
  n_bootstrap,
  n_thread = parallel::detectCores(),
  n_rep = 1,
  max_iter = 1000,
  tol = 1e-10
)
}
\arguments{
\item{model_null}{Fitted \code{poLCA} object, the null model}

\item{model_alt}{Fitted \code{poLCA} object, the alt model}

\item{n_bootstrap}{Number of bootstrap samples}

\item{n_thread}{Number of threads}

\item{n_rep}{Number of initial values to try when fitting on the bootstrap
samples}

\item{max_iter}{Maximum number of iterations for EM algorithm}

\item{tol}{Tolerance for difference in log likelihood, used for stopping
condition}
}
\value{
List containing the following:
\itemize{
\item \code{fitted_log_ratio}: log likelihood ratio comparing the null and alt models
\item \code{bootstrap_log_ratio}: vector of length \code{n_bootstrap}, bootstrapped log
likelihood ratio comparing the null and alt models
\item \code{p_value}: the proportion of bootstrap samples with log likelihood ratios
greater than the fitted log likelihood ratio
}
}
\description{
Does the bootstrap likelihood ratio test. Provide two fitted models, the null
model and the alt model fitted with a different number of clusters/latent
classes. Bootstrap samples are generated using the null model. The null model
and the alt model are refitted on the bootstrap samples to investigate the
log likelihood ratio of the two models.
}
\details{
Runs in parallel for each bootstrap sample, potentially high memory if the
data is large
}
