% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/der_vs_state.R
\name{der_vs_state_mlx}
\alias{der_vs_state_mlx}
\title{Generate Derivative versus State (Monolix)}
\usage{
der_vs_state_mlx(
  nn_name,
  min_state = NULL,
  max_state = NULL,
  inputs = NULL,
  est_parms = NULL,
  mlx_file = NULL,
  length_out = 100,
  time_nn = FALSE,
  act = "ReLU",
  beta = 20,
  transform = NULL
)
}
\arguments{
\item{nn_name}{(string) Name of the NN, e.g., \dQuote{c} for NNc(...)}

\item{min_state}{(numeric) Value of minimal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{max_state}{(numeric) Value of maximal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{inputs}{(numeric vector) Vector of input values for which derivatives should be calculated (optional if min_state and max_state is given)}

\item{est_parms}{(named vector; semi-optional) Named vector of estimated parameters from the NN extracted through the \emph{pre_fixef_extractor_mlx} function. For optionality, see \strong{Details}.}

\item{mlx_file}{(string; semi-optional) (path)/name of the Monolix run. Must include ".mlxtran" and estimation bust have been run previously. For optionality, see \strong{Details}.}

\item{length_out}{(numeric) Number of states between min_state and max_state for derivative calculations.}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}

\item{act}{(string) Activation function used in the NN. Currently "ReLU" and "Softplus" available.}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}

\item{transform}{(string) Mathematical exression as string to transform the NN output. Independent variable must be called NN, e.g.,
"1/(1+exp(-NN))" for sigmoidal transformation.}
}
\value{
Dataframe with columns for the state and the corresponding derivatives
}
\description{
This functions allows to generate derivative versus state data for a neural network from a NODE in Monolix.
}
\details{
Either \emph{est_parms} or \emph{mlx_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\author{
Dominic Bräm
}
\keyword{internal}
