% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.pmrm_fit}
\alias{tidy.pmrm_fit}
\title{Tidy a fitted PMRM.}
\usage{
\method{tidy}{pmrm_fit}(x, ...)
}
\arguments{
\item{x}{A fitted progression model for repeated measures (PMRM).}

\item{...}{Not used.}
}
\value{
A tidy \code{tibble} with one row for each treatment effect
model parameter (\code{theta}) and columns with the parameter name
(study arm and/or visit it corresponds to), estimate,
and standard error. This format aligns with the \code{tidy()}
method of similar fitted models in R.
}
\description{
Return tidy parameter summaries of a progression model
for repeated measures (PMRM).
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  tidy(fit)
}
\seealso{
Other estimates: 
\code{\link{VarCorr.pmrm_fit}()},
\code{\link{coef.pmrm_fit}()},
\code{\link{pmrm_marginals}()},
\code{\link{vcov.pmrm_fit}()}
}
\concept{estimates}
