% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.pmrm_fit}
\alias{print.pmrm_fit}
\title{Print a fitted PMRM.}
\usage{
\method{print}{pmrm_fit}(x, digits = 3L, ...)
}
\arguments{
\item{x}{A fitted progression model for repeated measures (PMRM).}

\item{digits}{Non-negative integer, number of digits for rounding.}

\item{...}{Not used.}
}
\value{
\code{NULL} (invisibly). Called for side effects
(printing to the R console).
}
\description{
Print a fitted progression model for repeated measures (PMRM).
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  print(fit)
}
\seealso{
Other visualization: 
\code{\link{plot.pmrm_fit}()}
}
\concept{visualization}
