% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{ape}
\alias{ape}
\title{Average Marginal Effects for Spatial Probit Models}
\usage{
ape(mod, variables = NULL)
}
\arguments{
\item{mod}{An object of class \code{"pmlsprobit"}.}

\item{variables}{Character vector specifying the names of covariates for which
marginal effects are computed. This option should be used only when the model
contains nonlinear terms in the specification \eqn{X \beta}.}
}
\value{
A named list with three elements corresponding to the average direct,
indirect, and total marginal effects for each covariate.
}
\description{
Computes average direct, indirect, and total marginal effects from an object
of class \code{"pmlsprobit"} using numerical derivatives.
}
\examples{
\donttest{
data(oldcol, package = "spdep")
dat <- COL.OLD
dat$y <- as.numeric(dat$CRIME > 35)

listw <- spdep::nb2listw(COL.nb, style = "W")

set.seed(857489)
mod <- pmlsbp(
  y ~ HOVAL + INC, data = dat, W = listw,
  model = "SAR", grouping = 7,
  mvtnorm_control = list(
    M = 25e2, sim_type = "mc",
    tol = .Machine$double.eps, fast = FALSE
  ),
  na.action = na.omit, spectral = TRUE,
  iterlim = 1e5
)

ape(mod)
}

}
\seealso{
Partial maximum likelihood estimation is implemented in
\code{\link{pmlsbp}}.
}
