% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldsc_rg.R
\name{ldsc_rg}
\alias{ldsc_rg}
\title{Estimate cross-trait genetic correlations (Robust Version) - refer to ldscr R package (https://github.com/mglev1n/ldscr)}
\usage{
ldsc_rg(
  munged_sumstats,
  sample_prev = NA,
  population_prev = NA,
  ld,
  wld,
  n_blocks = 200,
  chisq_max = NA,
  chr_filter = seq(1, 22, 1)
)
}
\arguments{
\item{munged_sumstats}{(list) A named list of dataframes, or paths to files containing munged summary statistics. Each set of munged summary statistics contain at least columns named `SNP` (rsid), `A1` (effect allele), `A2` (non-effect allele), `N` (total sample size) and `Z` (Z-score)}

\item{sample_prev}{(list) A named list containing the prevalence of cases in the current sample, used for conversion from observed heritability to liability-scale heritability. The default is `NA`, which is appropriate for quantitative traits or estimating heritability on the observed scale.}

\item{population_prev}{(list) A named list containing the population prevalence of the trait, used for conversion from observed heritability to liability-scale heritability. The default is `NA`, which is appropriate for quantitative traits or estimating heritability on the observed scale.}

\item{ld}{(character) Path to directory containing ld score files, ending in `*.l2.ldscore.gz`.}

\item{wld}{(character) Path to directory containing weight files.}

\item{n_blocks}{(numeric) Number of blocks used to produce block jackknife standard errors. Default is `200`}

\item{chisq_max}{(numeric) Maximum value of Z^2 for SNPs to be included in LD-score regression. Default is to set `chisq_max` to the maximum of 80 and N*0.001.}

\item{chr_filter}{(numeric vector) Chromosomes to include in analysis. Separating even/odd chromosomes may be useful for exploratory/confirmatory factor analysis.}
}
\value{
A list of class `ldscr_list` containing heritablilty and genetic correlation information
 - `h2` = [tibble][tibble::tibble-package] containing heritability information for each trait. If `sample_prev` and `population_prev` were provided, the heritability estimates will also be returned on the liability scale.
 - `rg` = [tibble][tibble::tibble-package] containing pairwise genetic correlations information.
 - `raw` = A list of correlation/covariance matrices
}
\description{
`ldsc_rg()` uses ldscore regression to estimate the pairwise genetic correlations between traits. The function relies on named lists of traits, sample prevalences, and population prevalences. The name of each trait should be consistent across each argument.
}
\details{
This function estimates the pairwise genetic correlations between an arbitrary number of traits. The function also estimates heritability for each individual trait. There is a [ggplot2::autoplot()] method for visualizing a heatmap of the results.

This version handles cases where traits have non-positive heritability estimates more gracefully by returning NA values for correlations involving such traits.
}
