% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{igDistance}
\alias{igDistance}
\title{Germline set alleles distance}
\usage{
igDistance(
  germline_set,
  AA = FALSE,
  method = c("decipher", "hamming", "lv"),
  trim_3prime = NULL,
  return_type = c("matrix", "dist"),
  quiet = TRUE
)
}
\arguments{
\item{germline_set}{A character vector of aligned allele sequences. See details for curating options.}

\item{AA}{Logical (FALSE by default). If TRUE, calculate the distance based on amino acid sequences.}

\item{method}{Distance calculation method. One of:
\itemize{
\item \code{"decipher"}: Uses DECIPHER::DistanceMatrix (requires aligned sequences, best for V segments)
\item \code{"hamming"}: Hamming distance (requires equal length, sequences padded if needed)
\item \code{"lv"}: Levenshtein distance (handles variable length, good for D/J segments)
}}

\item{trim_3prime}{Optional position to trim sequences from 3' end before distance calculation}

\item{return_type}{One of "matrix" (default) or "dist" to return a dist object}

\item{quiet}{Logical (TRUE by default). Suppress informative messages}
}
\value{
A \code{matrix} or \code{dist} object of the computed distances between allele pairs.
}
\description{
Calculates the distance between pairs of alleles based on their aligned germline sequences.
Supports multiple distance methods for different segment types.
}
\details{
The aligned IMGT IGHV allele germline set can be downloaded from the IMGT site
\url{https://www.imgt.org/} under the section genedb.

For V segments, the "decipher" method is recommended as it handles alignment gaps properly.
For D and J segments which may have variable lengths, the "lv" (Levenshtein) method is appropriate.
}
\examples{
data(HVGERM)
# Using DECIPHER method (default, for V segments)
d1 <- igDistance(HVGERM[1:10], method = "decipher")

# Using Hamming distance
d2 <- igDistance(HVGERM[1:10], method = "hamming")

# Using Levenshtein distance (good for D/J segments)
d3 <- igDistance(HVGERM[1:10], method = "lv")

}
\seealso{
\code{\link{ighvDistance}} for backward compatibility wrapper
}
