% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_outliers.r
\name{detect_outliers}
\alias{detect_outliers}
\title{Detect outliers in PhenoCam time series}
\usage{
detect_outliers(
  data,
  iterations = 20,
  sigma = 2,
  grvi = FALSE,
  snowflag = FALSE,
  plot = FALSE,
  internal = TRUE,
  out_dir = tempdir()
)
}
\arguments{
\item{data}{PhenoCam data structure or filename}

\item{iterations}{number of itterations in order to detect outliers ()}

\item{sigma}{number of deviations to exclude outliers at}

\item{grvi}{reverse the direction of the screening intervals
to accomodate for GRVI outliers}

\item{snowflag}{use manual snow flag labels as outliers}

\item{plot}{visualize the process, mostly for debugging
(\code{TRUE} / \code{FALSE} = default)}

\item{internal}{return a data structure if given a file on disk
(\code{TRUE} / \code{FALSE} = default)
to accomodate for GRVI outliers}

\item{out_dir}{output directory where to store data}
}
\description{
The function fills in the existing column to hold outlier flags,
and either overwrites the original file or outputs a data structure.
}
\examples{

\dontrun{
# download demo data (do not detect outliers)
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3",
                  outlier_detection = FALSE)

# detect outliers in the downloaded file
detect_outliers(file.path(tempdir(),"harvard_DB_1000_3day.csv"))

}
}
