% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advfq_ophtha.R
\docType{data}
\name{advfq_ophtha}
\alias{advfq_ophtha}
\title{Visual Function Questionnaire Analysis}
\format{
A data frame with 89 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ SITEID }{Study Site Identifier}
\item{ COUNTRY }{Country}
\item{ DOMAIN }{Domain Abbreviation}
\item{ RFSTDTC }{Subject Reference Start Date/Time}
\item{ RFENDTC }{Subject Reference End Date/Time}
\item{ RFXSTDTC }{Date/Time of First Study Treatment}
\item{ RFXENDTC }{Date/Time of Last Study Treatment}
\item{ RFPENDTC }{Date/Time of End of Participation}
\item{ SCRFDT }{Screen Failure Date}
\item{ FRVDT }{Final Retrieval Visit Date}
\item{ DTHDTC }{Date/Time of Death}
\item{ DTHADY }{Relative Day of Death}
\item{ DTHFL }{Subject Death Flag}
\item{ LDDTHELD }{Elapsed Days from Last Dose to Death}
\item{ LDDTHGR1 }{Last Dose to Death - Days Elapsed Grp 1}
\item{ DTH30FL }{Death Within 30 Days of Last Trt Flag}
\item{ DTHA30FL }{Death After 30 Days from Last Trt Flag}
\item{ DTHDOM }{Domain for Date of Death Collection}
\item{ DTHB30FL }{Death Within 30 Days of First Trt Flag}
\item{ ASEQ }{Analysis Sequence Number}
\item{ REGION1 }{Geographic Region 1}
\item{ DMDTC }{Date/Time of Collection}
\item{ DMDY }{Study Day of Collection}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ AGEGR1 }{Pooled Age Group 1}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ RACEGR1 }{Pooled Race Group 1}
\item{ ETHNIC }{Ethnicity}
\item{ SAFFL }{Safety Population Flag}
\item{ ARM }{Description of Planned Arm}
\item{ ARMCD }{Planned Arm Code}
\item{ ACTARM }{Description of Actual Arm}
\item{ ACTARMCD }{Actual Arm Code}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTSTMF }{Time of First Exposure Imput. Flag}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ TRTETMF }{Time of Last Exposure Imput. Flag}
\item{ EOSSTT }{End of Study Status}
\item{ EOSDT }{End of Study Date}
\item{ RFICDTC }{Date/Time of Informed Consent}
\item{ RANDDT }{Date of Randomization}
\item{ LSTALVDT }{Date Last Known Alive}
\item{ TRTDURD }{Total Treatment Duration (Days)}
\item{ DTHDT }{Date of Death}
\item{ DTHDTF }{Date of Death Imputation Flag}
\item{ DTHCAUS }{Cause of Death}
\item{ DTHCGR1 }{Cause of Death Reason 1}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ PARCAT1 }{Parameter Category 1}
\item{ PARCAT2 }{Parameter Category 2}
\item{ AVAL }{Analysis Value}
\item{ AVALC }{Analysis Value (C)}
\item{ BASE }{Baseline Value}
\item{ CHG }{Change from Baseline}
\item{ PCHG }{Percent Change from Baseline}
\item{ ABLFL }{Baseline Record Flag}
\item{ ANL01FL }{Analysis Flag 01}
\item{ ONTRTFL }{On Treatment Record Flag}
\item{ QSSEQ }{Sequence Number}
\item{ QSTESTCD }{Question Short Name}
\item{ QSTEST }{Question Name}
\item{ QSCAT }{Category of Question}
\item{ QSSCAT }{Subcategory for Question}
\item{ QSORRES }{Finding in Original Units}
\item{ QSORRESU }{Original Units}
\item{ QSSTRESC }{Character Result/Finding in Std Format}
\item{ QSSTRESN }{Numeric Finding in Standard Units}
\item{ QSSTRESU }{Standard Units}
\item{ QSBLFL }{Baseline Flag}
\item{ QSDRVFL }{Derived Flag}
\item{ VISITNUM }{Visit Number}
\item{ VISIT }{Visit Name}
\item{ VISITDY }{Planned Study Day of Visit}
\item{ QSDTC }{Date/Time of Finding}
\item{ QSDY }{Study Day of Finding}
}
}
\source{
Generated from admiralophtha package (template ad_advfq.R).
}
\usage{
advfq_ophtha
}
\description{
Visual Function Questionnaire Analysis
}
\details{
Contains a set of 11 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
QBCSCORE \tab Composite Score        \cr
QR01     \tab Recoded Item - 01      \cr
QR02     \tab Recoded Item - 02      \cr
QR03     \tab Recoded Item - 03      \cr
QR04     \tab Recoded Item - 04      \cr
QSG01    \tab General Score 01       \cr
QSG02    \tab General Score 02       \cr
VFQ1     \tab Overall Health         \cr
VFQ2     \tab Eyesight in Both Eyes  \cr
VFQ3     \tab Worry About Eyesight   \cr
VFQ4     \tab Pain in and Around Eyes
}
}
\examples{
data("advfq_ophtha")
}
\references{
None
}
\keyword{dataset}
\keyword{ophthalmology}
