% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adlb_metabolic.R
\docType{data}
\name{adlb_metabolic}
\alias{adlb_metabolic}
\title{Laboratory Analysis for Metabolic}
\format{
A data frame with 43 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ DOMAIN }{Domain Abbreviation}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ PARAMN }{Parameter (N)}
\item{ PARCAT1 }{Parameter Category 1}
\item{ PARCAT2 }{Parameter Category 2}
\item{ AVAL }{Analysis Value}
\item{ AVALC }{Analysis Value (C)}
\item{ ANRLO }{Analysis Normal Range Lower Limit}
\item{ ANRHI }{Analysis Normal Range Upper Limit}
\item{ LBSEQ }{Sequence Number}
\item{ LBTESTCD }{Lab Test or Examination Short Name}
\item{ LBTEST }{Lab Test or Examination Name}
\item{ LBCAT }{Category for Lab Test}
\item{ LBORRES }{Result or Finding in Original Units}
\item{ LBORRESU }{Original Units}
\item{ LBORNRLO }{Reference Range Lower Limit in Orig Unit}
\item{ LBORNRHI }{Reference Range Upper Limit in Orig Unit}
\item{ LBSTRESC }{Character Result/Finding in Std Format}
\item{ LBSTRESN }{Numeric Result/Finding in Standard Units}
\item{ LBSTRESU }{Standard Units}
\item{ LBSTNRLO }{Reference Range Lower Limit-Std Units}
\item{ LBSTNRHI }{Reference Range Upper Limit-Std Units}
\item{ LBNRIND }{Reference Range Indicator}
\item{ LBBLFL }{Baseline Flag}
\item{ LBFAST }{Fasting Status}
\item{ VISITNUM }{Visit Number}
\item{ VISIT }{Visit Name}
\item{ VISITDY }{Planned Study Day of Visit}
\item{ LBDTC }{Date/Time of Specimen Collection}
\item{ LBDY }{Study Day of Specimen Collection}
\item{ BMI }{Body Mass Index (kg/m2)}
\item{ WSTCIR }{Waist Circumference (cm)}
}
}
\source{
Generated from admiralmetabolic package (template ad_adlb.R).
}
\usage{
adlb_metabolic
}
\description{
Laboratory Analysis for Metabolic
}
\details{
Contains a set of 11 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
ALB      \tab Albumin (g/L)                                    \cr
ALKPH    \tab Alkaline Phosphatase (U/L)                       \cr
AST      \tab Aspartate Aminotransferase (U/L)                 \cr
CHOLES   \tab Cholesterol (mmol/L)                             \cr
FLI      \tab Fatty Liver Index                                \cr
GGT      \tab Gamma Glutamyl Transferase (U/L)                 \cr
GLUC     \tab Glucose (mmol/L)                                 \cr
HBA1CHGB \tab Hemoglobin A1C/Hemoglobin (mmol/mol)             \cr
HOMAIR   \tab Homeostasis Model Assessment - Insulin Resistance\cr
INSULIN  \tab Insulin (mIU/L)                                  \cr
TRIG     \tab Triglycerides (mg/dL)
}
}
\examples{
data("adlb_metabolic")
}
\references{
None
}
\keyword{dataset}
\keyword{metabolic}
