% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-example_writing.R
\docType{data}
\name{example_openai_batch_output}
\alias{example_openai_batch_output}
\title{Example OpenAI Batch output (JSONL lines)}
\format{
A character vector of length 3, where each element is a
single JSON line (JSONL).
}
\usage{
data("example_openai_batch_output")
}
\description{
A small character vector containing three example lines from an
OpenAI Batch API output file in JSONL format. Each element is a
single JSON object representing the result for one batch request.
}
\details{
The structure follows the current Batch API output schema, with
fields such as \code{id}, \code{custom_id}, and a nested
\code{response} object containing \code{status_code},
\code{request_id}, and a \code{body} that resembles a regular
chat completion response. One line illustrates a successful
comparison where \code{<BETTER_SAMPLE>SAMPLE_1</BETTER_SAMPLE>}
is returned, one illustrates a case where SAMPLE_2 is preferred,
and one illustrates an error case with a non-200 status.

This dataset is designed for use in examples and tests of batch
output parsing functions. Typical usage is to write the lines to
a temporary file and then read/parse them as a JSONL batch file.
}
\examples{
data("example_openai_batch_output")

# Inspect the first line
cat(example_openai_batch_output[1], "\n")

# Write to a temporary .jsonl file for parsing
tmp <- tempfile(fileext = ".jsonl")
writeLines(example_openai_batch_output, con = tmp)
tmp

}
\keyword{datasets}
