% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{vis_1_param}
\alias{vis_1_param}
\title{Visualise the distribution of a single parameter}
\usage{
vis_1_param(
  df,
  param = NULL,
  binwidth = NULL,
  type = "histogram",
  dist = NULL,
  user_dist = NULL,
  user_param_1 = NULL,
  user_param_2 = NULL,
  user_mean = NULL
)
}
\arguments{
\item{df}{a dataframe.}

\item{param}{character. Name of variable of the dataframe for which the distribution should be plotted.}

\item{binwidth}{numeric. Determine the width of the bins to use, only applied in combination with "histogram". Default is 30 bins.}

\item{type}{character. Determine which plot to return: "histogram" for a histogram, "density" for a density plot. Default is "histogram".}

\item{dist}{character or vector of character. Determine which distribution to fit on the density plot.}

\item{user_dist}{character string. User-defined distribution to fit. Default value is NULL.}

\item{user_param_1}{character string. First parameter of the user-defined distribution to fit.}

\item{user_param_2}{character string. Second parameter of the user-defined distribution to fit.}

\item{user_mean}{numeric value. mean value to plot on the graph. Default is NULL}
}
\value{
A ggplot2 graph.
}
\description{
This function plots the distribution of a single parameter.
}
\details{
The available distributions are: "norm" (normal), "beta", "gamma", "lnorm" (lognormal). TO CHECK --> ask for mean and SD/SE for the user-defined distribution???
}
\examples{
# Generating histogram for the costs of progression-free health state, bins of 50 euros
data(df_pa)
vis_1_param(df = df_pa, param = "c_pfs", binwidth = 50)
}
