% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_map_notes.R
\name{osm_read_bbox_notes}
\alias{osm_read_bbox_notes}
\title{Retrieve notes by bounding box}
\usage{
osm_read_bbox_notes(
  bbox,
  limit = 100,
  closed = 7,
  format = c("R", "sf", "xml", "rss", "json", "gpx")
)
}
\arguments{
\item{bbox}{Coordinates for the area to retrieve the notes from (\verb{left,bottom,right,top}). Floating point numbers in
degrees, expressing a valid bounding box, not larger than the configured size limit, 25 square degrees, not
overlapping the dateline. It can be specified by a character, matrix, vector, \code{bbox} object from \pkg{sf}, a
\code{SpatExtent} from \pkg{terra}. Unnamed vectors and matrices will be sorted appropriately and must merely be in the
order (\code{x}, \code{y}, \code{x}, \code{y}) or \code{x} in the first column and \code{y} in the second column.}

\item{limit}{Specifies the number of entries returned at max. A value between 1 and 10000 is valid. Default to 100.}

\item{closed}{Specifies the number of days a note needs to be closed to no longer be returned. A value of 0 means
only open notes are returned. A value of -1 means all notes are returned. Default to 7.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"sf"} \code{"xml"}, \code{"rss"}, \code{"json"} or \code{"gpx"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one map note per row. If \code{format = "sf"}, returns a \code{sf} object from
\pkg{sf}.
\subsection{\code{format = "xml"}}{

Returns a \link[xml2:oldclass]{xml2::xml_document} with the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<?xml version="1.0" encoding="UTF-8"?>
<osm version="0.6" generator="OpenStreetMap server" copyright="OpenStreetMap and contributors" attribution="https://www.openstreetmap.org/copyright" license="https://opendatacommons.org/licenses/odbl/1-0/">
  <note lon="0.1000000" lat="51.0000000">
    <id>16659</id>
    <url>https://master.apis.dev.openstreetmap.org/api/0.6/notes/16659</url>
    <comment_url>https://master.apis.dev.openstreetmap.org/api/0.6/notes/16659/comment</comment_url>
    <close_url>https://master.apis.dev.openstreetmap.org/api/0.6/notes/16659/close</close_url>
    <date_created>2019-06-15 08:26:04 UTC</date_created>
    <status>open</status>
    <comments>
      <comment>
        <date>2019-06-15 08:26:04 UTC</date>
        <uid>1234</uid>
        <user>userName</user>
        <user_url>https://master.apis.dev.openstreetmap.org/user/userName</user_url>
        <action>opened</action>
        <text>ThisIsANote</text>
        <html>&lt;p&gt;ThisIsANote&lt;/p&gt;</html>
      </comment>
      ...
    </comments>
  </note>
  ...
</osm>
}\if{html}{\out{</div>}}
}

\subsection{\code{format = "json"}}{

Returns a list with the following json structure:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "type": "FeatureCollection",
  "features": [
    \{
      "type": "Feature",
      "geometry": \{"type": "Point", "coordinates": [0.1000000, 51.0000000]\},
      "properties": \{
        "id": 16659,
        "url": "https://master.apis.dev.openstreetmap.org/api/0.6/notes/16659.json",
        "comment_url": "https://master.apis.dev.openstreetmap.org/api/0.6/notes/16659/comment.json",
        "close_url": "https://master.apis.dev.openstreetmap.org/api/0.6/notes/16659/close.json",
        "date_created": "2019-06-15 08:26:04 UTC",
        "status": "open",
        "comments": [
          \{"date": "2019-06-15 08:26:04 UTC", "uid": 1234, "user": "userName", "user_url": "https://master.apis.dev.openstreetmap.org/user/userName", "action": "opened", "text": "ThisIsANote", "html": "<p>ThisIsANote</p>"\},
          ...
        ]
      \}
    \}
  ]
\}
}\if{html}{\out{</div>}}
}

\subsection{\code{format = "rss"} & \code{format = "gpx"}}{

For \code{format} in \code{"rss"}, and \code{"gpx"}, a \link[xml2:oldclass]{xml2::xml_document} with the corresponding format.
}
}
\description{
Returns the existing notes in the specified bounding box. The notes will be ordered by the date of their last change,
the most recent one will be first.
}
\note{
The comment properties (\code{uid}, \code{user}, \code{user_url}) will be omitted if the comment was anonymous.
}
\examples{
notes <- osm_read_bbox_notes(bbox = c(3.7854767, 39.7837403, 4.3347931, 40.1011851), limit = 10)
## bbox as a character value also works (bbox = "3.7854767,39.7837403,4.3347931,40.1011851").
notes
}
\seealso{
Other get notes' functions: 
\code{\link{osm_feed_notes}()},
\code{\link{osm_get_notes}()},
\code{\link{osm_search_notes}()}
}
\concept{get notes' functions}
