% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.optweight.R
\name{summary.optweight}
\alias{summary.optweight}
\alias{summary.optweightMV}
\alias{summary.optweight.svy}
\alias{plot.summary.optweight}
\title{Summarize, Print, and Plot Information about Estimated Weights}
\usage{
\method{summary}{optweight}(object, top = 5L, ignore.s.weights = FALSE, weight.range = TRUE, ...)

\method{summary}{optweightMV}(object, top = 5L, ignore.s.weights = FALSE, weight.range = TRUE, ...)

\method{summary}{optweight.svy}(object, top = 5L, ignore.s.weights = FALSE, weight.range = TRUE, ...)

\method{plot}{summary.optweight}(x, ...)
}
\arguments{
\item{object}{an \code{optweight}, \code{optweightMV}, or \code{optweight.svy} object; the output of a call to \code{\link[=optweight]{optweight()}}, \code{\link[=optweightMV]{optweightMV()}}, or \code{\link[=optweight.svy]{optweight.svy()}}.}

\item{top}{\code{integer}; how many of the largest and smallest weights to display. Default
is 5. Ignored when \code{weight.range = FALSE}.}

\item{ignore.s.weights}{logical\verb{; whether to ignore sampling weights when computing the weight summary. Default is }FALSE`.}

\item{weight.range}{\code{logical}; whether to display statistics about the range of weights and the highest and lowest weights for each group. Default is \code{TRUE}.}

\item{...}{Additional arguments. For \code{plot()}, additional arguments passed to \code{\link[graphics:hist]{graphics::hist()}} to determine the number of bins, though \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}} from \pkg{ggplot2} is actually used to create the plot.}

\item{x}{a \code{summary.optweight}, \code{summary.optweightMV}, or \code{summary.optweight.svy} object; the output of a call to \code{summary.optweight()}, \code{summary.optweightMV()}, or ()\code{summary.optweight.svy}.}
}
\value{
For point treatments (i.e., \code{optweight} objects), \code{summary()} returns a \code{summary.optweight} object with the following
elements:
\item{weight.range}{The range (minimum and maximum) weight for each treatment group.}
\item{weight.top}{The units with the greatest weights in each treatment group; how many are included is determined by \code{top}.}
\item{l2}{The square root of the \eqn{L_2} norm of the estimated weights from the base weights, weighted by the sampling weights (if any): \eqn{\sqrt{\frac{1}{n}\sum_i {s_i(w_i - b_i)^2}}}}
\item{l1}{The \eqn{L_1} norm of the estimated weights from the base weights, weighted by the sampling weights (if any): \eqn{\frac{1}{n}\sum_i {s_i \vert w_i - b_i \vert}}}
\item{linf}{The \eqn{L_\infty} norm (maximum absolute deviation) of the estimated weights from the base weights: \eqn{\max_i {\vert w_i - b_i \vert}}}
\item{rel.ent}{The relative entropy between the estimated weights and the base weights, weighted by the sampling weights (if any): \eqn{\frac{1}{n}\sum_i {s_i w_i \log\left(\frac{w_i}{b_i}\right)}}. Only computed if all weights are positive.}
\item{num.zeros}{The number of units with a weight equal to 0.}
\item{effective.sample.size}{The effective sample size for each treatment group before and after weighting.}

For multivariate treatments (i.e., \code{optweightMV} objects), a list of the above elements for each treatment.

For \code{optweight.svy} objects, the above object but with no treatment group divisions.

\code{plot()} returns a \code{ggplot} object with a histogram displaying the
distribution of the estimated weights. If the estimand is the ATT or ATC,
only the weights for the non-focal group(s) will be displayed (since the
weights for the focal group are all 1). A dotted line is displayed at the
mean of the weights (the mean of the base weights, or 1 if not supplied).
}
\description{
These functions summarize the weights resulting from a call to \code{\link[=optweight]{optweight()}}, \code{\link[=optweightMV]{optweightMV()}}, or \code{\link[=optweight.svy]{optweight.svy()}}. \code{summary()} produces summary statistics on the distribution of weights, including their range and variability, and the effective sample size of the weighted sample (computed using the formula in McCaffrey, et al., 2004). \code{plot()} creates a histogram of the weights.
}
\examples{
\dontshow{if (rlang::is_installed("cobalt")) withAutoprint(\{ # examplesIf}
library("cobalt")
data("lalonde", package = "cobalt")

#Balancing covariates between treatment groups (binary)
(ow1 <- optweight(treat ~ age + educ + married +
                    nodegree + re74, data = lalonde,
                  tols = .001,
                  estimand = "ATT"))

(s <- summary(ow1))

plot(s, breaks = 12)
\dontshow{\}) # examplesIf}
}
\references{
McCaffrey, D. F., Ridgeway, G., & Morral, A. R. (2004).
Propensity Score Estimation With Boosted Regression for Evaluating Causal
Effects in Observational Studies. \emph{Psychological Methods}, 9(4), 403–425. \doi{10.1037/1082-989X.9.4.403}
}
\seealso{
\code{\link[=plot.optweight]{plot.optweight()}} for plotting the values of the dual variables.
}
