% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_image}
\alias{wb_add_image}
\title{Insert an image into a worksheet}
\usage{
wb_add_image(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  file,
  width = 6,
  height = 3,
  row_offset = 0,
  col_offset = 0,
  units = "in",
  dpi = 300,
  address = NULL,
  ...
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object.}

\item{sheet}{The name or index of the worksheet to receive the image.
Defaults to the current sheet.}

\item{dims}{A character string defining the placement. A single cell (e.g., "A1")
uses a one-cell anchor; a range (e.g., "A1:D4") uses a two-cell anchor.}

\item{file}{The path to the image file. Supported formats are JPEG, PNG, and BMP.}

\item{width, height}{The numeric width and height of the image.}

\item{row_offset, col_offset}{Offset vectors for fine-tuning the position within
the anchor cell(s).}

\item{units}{The units for \code{width} and \code{height}. Must be one of \code{"in"} (inches),
\code{"cm"} (centimeters), or \code{"px"} (pixels).}

\item{dpi}{The resolution (dots per inch) used for conversion when \code{units}
is set to \code{"px"}. Defaults to 300.}

\item{address}{An optional character string specifying a URL, file path, or
"mailto:" link to be opened when the image is clicked.}

\item{...}{Additional arguments. Includes support for legacy \code{start_row} and
\code{start_col} parameters.}
}
\description{
The \code{wb_add_image()} function embeds external image files into a worksheet. It
supports standard raster formats and provides granular control over positioning
through a variety of anchoring methods. Images can be anchored to absolute
positions, individual cells, or defined ranges, and can optionally function
as clickable hyperlinks.
}
\details{
Image placement is determined by the \code{dims} argument and internal anchoring
logic. If a single cell is provided (e.g., "A1"), the image is placed using a
one-cell anchor where the top-left corner is fixed to the cell. If a range
is provided (e.g., "A1:D4"), a two-cell anchor is utilized, which can cause
the image to scale with the underlying rows and columns.

Position offsets (\code{row_offset} and \code{col_offset}) allow for sub-cell precision
by shifting the image from its anchor point. Internally, all dimensions are
converted to English Metric Units (EMUs), where 1 inch equals 914,400 EMUs,
ensuring high-fidelity rendering across different display scales.

Supported file types include \code{"jpeg"}, \code{"png"}, and \code{"bmp"}. If an \code{address}
is provided, the function creates a relationship to an external target or
email, transforming the image into a functional hyperlink.
}
\examples{
img <- system.file("extdata", "einstein.jpg", package = "openxlsx2")

wb <- wb_workbook()$
  add_worksheet()$
  add_image("Sheet 1", dims = "C5", file = img, width = 6, height = 5)$
  add_worksheet()$
  add_image(dims = "B2", file = img)$
  add_worksheet()$
  add_image(dims = "G3", file = img, width = 15, height = 12, units = "cm")
}
\seealso{
\code{\link[=wb_add_chart_xml]{wb_add_chart_xml()}} \code{\link[=wb_add_drawing]{wb_add_drawing()}} \code{\link[=wb_add_mschart]{wb_add_mschart()}} \code{\link[=wb_add_plot]{wb_add_plot()}}
}
