% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notcore_utils.r
\name{plot.vacalibration}
\alias{plot.vacalibration}
\title{Plot CSMF from a vacalibration object}
\usage{
\method{plot}{vacalibration}(
  x,
  type = c("errorbar", "bar", "compare")[1],
  algorithm = NULL,
  uncalibrated = FALSE,
  top = 10,
  title = "Top CSMF Distribution",
  xlab = "Causes",
  ylab = "CSMF",
  horiz = TRUE,
  angle = 60,
  fill = "lightblue",
  fill_uncalibrated = "lightpink",
  err_width = 0.4,
  err_size = 0.6,
  point_size = 2,
  border = "black",
  bw = TRUE,
  plot_it = TRUE,
  ...
)
}
\arguments{
\item{x}{Fitted \code{"vacalibration"} objects}

\item{type}{An indicator of the type of chart to plot. "errorbar" for line
plots of only the error bars on single population; "bar" for bar chart with
error bars on single population; "compare" for line charts on multiple
calibrated algorithms.}

\item{algorithm}{Name or vector of names of algorithm(s) which
limits the output to those specific results}

\item{uncalibrated}{Logical (TRUE/FALSE) indicator for including the
uncalibrated CSMF in the plots (not valid with \code{type} is set to
"compare").}

\item{top}{The number of top causes (in the calibrated CSMF) to plot. If
results from multiple algorithms are included in the fitted "vacalibration"
object and \code{type} is set to "compare", it will plot the union of the
top causes in all algorithms.}

\item{title}{Title of the plot.}

\item{xlab}{Labels for the causes.}

\item{ylab}{Labels for the CSMF values.}

\item{horiz}{Logical indicator indicating if the bars are plotted
horizontally.}

\item{angle}{Angle of rotation for the texts on x axis when \code{horiz} is
set to FALSE}

\item{fill}{The color to fill the bars when \code{type} is set to "bar".}

\item{fill_uncalibrated}{The color to fill the bars for the uncalibrated
CSMFs when \code{type} is set to "bar".}

\item{err_width}{Size of the error bars.}

\item{err_size}{Thickness of the error bar lines.}

\item{point_size}{Size of the points.}

\item{border}{The color to color the borders of bars when \code{type} is set
to "bar".}

\item{bw}{Logical indicator for setting the theme of the plots to be black
and white.}

\item{plot_it}{Logical (TRUE/FALSE) indicating if the first plot should
be rendered.}

\item{\dots}{Not used.}
}
\value{
A list of plots for each algorithms included in the fitted
"vacalibration" object.
}
\description{
Plot CSMF from a vacalibration object
}
\examples{
\dontrun{
data(NeonatesVA5)
fit_insilico <- codeVA(NeonatesVA5)
insilico_prep <- prepCalibration(fit_insilico)
calib_insilico = vacalibration::vacalibration(va_data = insilico_prep,
                                              age_group = "neonate",
                                              country = "Mozambique")

fit_interva <- codeVA(NeonatesVA5, model = "InterVA", version = "5", write = FALSE)
interva_prep <- prepCalibration(fit_interva)
calib_interva = vacalibration::vacalibration(va_data = interva_prep,
                                             age_group = "neonate",
                                             country = "Mozambique")
                                             
two_fits <- prepCalibration(fit_insilico, fit_interva)
calib_ensemble = vacalibration::vacalibration(va_data = two_fits,
                                              age_group = "neonate",
                                              country = "Mozambique")
plot(calib_ensemble)
}
}
