% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resource_exists}
\alias{opal.resource_exists}
\title{Check a resource reference exists}
\usage{
opal.resource_exists(opal, project, resource)
}
\arguments{
\item{opal}{Opal object.}

\item{project}{Name of the project.}

\item{resource}{Name of the resource in the project.}
}
\value{
A logical
}
\description{
Check whether a resource already exists in the project (and is visible by the requesting user).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resource_exists(o, 'RSRC', 'CNSIM1')
opal.logout(o)
}
}
\seealso{
Other resource functions: 
\code{\link{opal.resource}()},
\code{\link{opal.resource_create}()},
\code{\link{opal.resource_delete}()},
\code{\link{opal.resource_extension_create}()},
\code{\link{opal.resource_get}()},
\code{\link{opal.resource_perm}()},
\code{\link{opal.resource_perm_add}()},
\code{\link{opal.resource_perm_delete}()},
\code{\link{opal.resources}()},
\code{\link{opal.resources_perm}()},
\code{\link{opal.resources_perm_add}()},
\code{\link{opal.resources_perm_delete}()}
}
\concept{resource functions}
