% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods.R
\name{glean}
\alias{glean}
\title{Extract specified data from a set of responses}
\usage{
glean(res, ...)
}
\arguments{
\item{res}{An object of type \code{ohvbd.responses} or \code{ohvbd.ad.matrix} generated from \code{\link[=fetch]{fetch()}}
and containing data from one of the supported databases.}

\item{...}{Any arguments to be passed to the underlying extractors (unused).}
}
\value{
The extracted data, either as an \code{ohvbd.data.frame} or \code{ohvbd.ad.matrix} object.
}
\description{
This is a convenience method that infers and applies the correct extractor for the input
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
search_hub("Ixodes", "vt") |> fetch() |> glean(cols=c("Interactor1Species"))
fetch_ad(use_cache=TRUE) |> glean(targetdate="2020-08-04")
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{convenience}
