% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{batch_report}
\alias{batch_report}
\title{Generate HTML Report for Batch Comparison Results}
\usage{
batch_report(
  object,
  output_file = NULL,
  title = "odiffr Comparison Report",
  embed = FALSE,
  relative_paths = FALSE,
  n_worst = 10,
  show_all = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{odiffr_batch} object from \code{\link[=compare_images_batch]{compare_images_batch()}} or
\code{\link[=compare_image_dirs]{compare_image_dirs()}}.}

\item{output_file}{Path to write the HTML file. If NULL, returns HTML as
a character string.}

\item{title}{Report title. Default: "odiffr Comparison Report".}

\item{embed}{If TRUE, embed diff images as base64 data URIs for a fully
self-contained file. If FALSE (default), link to image files on disk.}

\item{relative_paths}{If TRUE and \code{output_file} is specified, use paths
relative to the report location for image \code{src} attributes. This makes
reports portable without embedding. Ignored when \code{embed = TRUE}. Default:
FALSE.}

\item{n_worst}{Number of worst offenders to display. Default: 10.}

\item{show_all}{If TRUE, include a table of all comparisons. Default: FALSE.}

\item{...}{Additional arguments passed to \code{\link[=summary.odiffr_batch]{summary.odiffr_batch()}}.}
}
\value{
If \code{output_file} is NULL, returns the HTML as a character string
(invisibly). If \code{output_file} is specified, writes the file and returns
the file path (invisibly).
}
\description{
Creates a standalone HTML report summarizing batch image comparison results.
Includes pass/fail statistics, failure reasons, diff statistics, and
thumbnails of the worst offenders.
}
\details{
Diff image thumbnails (or embedded images when \code{embed = TRUE}) are only
shown for comparisons where a \code{diff_output} file was created. This requires
using \code{diff_dir} in \code{\link[=compare_images_batch]{compare_images_batch()}} or \code{\link[=compare_image_dirs]{compare_image_dirs()}}.
Comparisons without diff images will show "No diff" in the preview column.
}
\examples{
\dontrun{
results <- compare_image_dirs("baseline/", "current/", diff_dir = "diffs/")

# Generate report file
batch_report(results, output_file = "report.html")

# Self-contained report with embedded images
batch_report(results, output_file = "report.html", embed = TRUE)

# Get HTML as string
html <- batch_report(results)
}
}
\seealso{
\code{\link[=compare_images_batch]{compare_images_batch()}}, \code{\link[=compare_image_dirs]{compare_image_dirs()}},
\code{\link[=summary.odiffr_batch]{summary.odiffr_batch()}}
}
