#' Metadata for the package
#'
#' This dataset has the list of OD surveys available
#' in the package.
#' @keywords datasets
#' @format ## `metadata`
#' A data frame with 4 columns:
#' \describe{
#'  \item{city}{City name}
#'  \item{year}{Year of the survey}
#'  \item{harmonized}{A logical value showing whether the dataset was harmonized}
#'  \item{language}{Language of the dictionary}
#'  }
"metadata"

#' Sao Paulo OD Survey Dictionary
#'
#' @description
#' These datasets contain the dictionary for the OD surveys in Sao Paulo.
#' Each row describes one column of the survey data frame.
#'
#' @name dictSP
#' @keywords Dictionary
#' @format A data frame with 4 columns:
#' \describe{
#'  \item{variable_name}{Name of the variable}
#'  \item{description}{Description of the variable}
#'  \item{categories}{Examples of the categories in the variable}
#'  \item{class}{Class of the variable}
#'  }
#' @source <https://transparencia.metrosp.com.br/dataset/pesquisa-origem-e-destino>
"od_sao_paulo_1977_not_harmonized_dictionary_en"

#' @rdname dictSP
"od_sao_paulo_1977_not_harmonized_dictionary_es"

#' @rdname dictSP
"od_sao_paulo_1977_not_harmonized_dictionary_pt"

#' @rdname dictSP
"od_sao_paulo_1987_not_harmonized_dictionary_en"

#' @rdname dictSP
"od_sao_paulo_1987_not_harmonized_dictionary_es"

#' @rdname dictSP
"od_sao_paulo_1987_not_harmonized_dictionary_pt"

#' @rdname dictSP
"od_sao_paulo_1997_not_harmonized_dictionary_en"

#' @rdname dictSP
"od_sao_paulo_1997_not_harmonized_dictionary_es"

#' @rdname dictSP
"od_sao_paulo_1997_not_harmonized_dictionary_pt"

#' @rdname dictSP
"od_sao_paulo_2007_not_harmonized_dictionary_en"

#' @rdname dictSP
"od_sao_paulo_2007_not_harmonized_dictionary_es"

#' @rdname dictSP
"od_sao_paulo_2007_not_harmonized_dictionary_pt"

#' @rdname dictSP
"od_sao_paulo_2017_not_harmonized_dictionary_en"

#' @rdname dictSP
"od_sao_paulo_2017_not_harmonized_dictionary_es"

#' @rdname dictSP
"od_sao_paulo_2017_not_harmonized_dictionary_pt"
