% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra.R
\name{obm_repo}
\alias{obm_repo}
\title{Repozitorium manager function}
\usage{
obm_repo(scope = NULL, data_table = NULL, params = NULL)
}
\arguments{
\item{scope}{get or put}

\item{data_table}{OBM project table}

\item{params}{list which contains parameters for repozitorium}
}
\value{
data frame or boolean
}
\description{
This experimental function allows manage Dataverse repozitorium and datasets.
}
\details{
The following code *illustrates* how you could use this function in practice,
but it is **not meant to be run directly** (e.g., depends on external data).

\preformatted{
# Set the default server/project-repo for each of the following operations
#   - default is 0
#   - get possible names from server_conf query above
obm_repo('set', params=list(REPO='ABC-REPO'))
obm_repo('set', params=list(REPO='ABC-REPO', PARENT='dataverse/parent'))

# Listing dataverse
results <- obm_repo('get', params=list(type='dataverse', contents=1))
results <- obm_repo('get', params=list(type='dataverse'))

# Getting content of the named dataverse
results <- obm_repo('get', params=list(id='MY-DATAVERSE'))

# Get JSON Representation of a Dataset
results <- obm_repo('get', params=list(type='datasets', 
                                       persistentUrl='https://doi.org/xxx/xxx/xxx'))
results <- obm_repo('get', params=list(type='datasets', id='XABC-1'))

# Get versions of dataset
results <- obm_repo('get',params=list(type='datasets', id=42, version=''))
results <- obm_repo('get',params=list(type='datasets', id=42, version=':draft'))

# Get files of dataset
results <- obm_repo('get',params=list(type='datasets', id=42, files='', version=''))

# Get a file
results<-obm_repo('get',params=list(type='datafile', id=83))
results<-obm_repo('get',params=list(type='datafile', id=83, version=':draft'))

# Create a dataverse
results <- obm_repo('put',params=list(type='dataverse'))

# Create a dateset
results <- obm_repo('put',params=list(type='datasets', dataverse='my_dataset'))

# Add file to dataset (referenced by id or persistentUrl)
results <- obm_repo('put',params=list(type='datafile', 
                                      file='examples/test_upload.csv',
                                      id='XABC-1' ))
results <- obm_repo('put',params=list(type='datafile', 
                                      file='examples/test_upload.csv', 
                                      persistentUrl='https://doi.org/xxx/xxx/xxx'))

# Add object as file to dataset (referenced by id or persistentUrl)
# - automatically convert data object to JSON
# - returning with the last file's state
init.df <- data.frame()
results <- obm_repo('put',params=list(type='datafile', 
                                      id='XABC-1', 
                    data=list(results=res.list,
                              init_params=init.df)))

# Delete file
results <- obm_repo('delete',params=list(type='datafile',
                                         id='XABC-1',
                                         PARENT_DATAVERSE='dataverse/parent'))

# Set settings
# obm_repo('set',params=list(type='dataset',id='XABC-1'))
}
}
\examples{
\donttest{
# Getting server conf
results <- obm_repo('get', params=list(server_conf=1))
}

}
\keyword{repozitorium}
