% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{obm_init}
\alias{obm_init}
\title{Initialise connection to an OpenBioMaps server}
\usage{
obm_init(
  project = "",
  url = "openbiomaps.org",
  scope = c(),
  verbose = FALSE,
  api_version = 3
)
}
\arguments{
\item{project}{Which project you would like to connect? It has a short name.}

\item{url}{project server's web url DEFAULT is https://openbiomaps.org}

\item{scope}{vector of required scopes. DEFAULT is ok usually}

\item{verbose}{print verbose feedback messages - default is FALSE}

\item{api_version}{API version. 3.0 or higher enables the new REST and GraphQL API.}
}
\value{
boolean
}
\description{
This function is initiating an OBM connection.
}
\examples{
\donttest{
# connect with API v3 to the dead_animals project on the default openbiomaps.org server
obm_init(project='dead_animals')
# connect to a database on the default server (openbiomaps.org) with API v2.5
obm_init(project='dead_animals', api_version=2.5)
# connect on the local server instance to the butterfly database project
obm_init(url='http://localhost/biomaps',project='butterflies')
}
}
\keyword{connect}
\keyword{initiate}
\keyword{openbiomaps}
