% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{obm_get}
\alias{obm_get}
\title{Get Information/Data from an OpenBioMaps project}
\usage{
obm_get(
  scope = "",
  control_condition = NULL,
  condition = NULL,
  table = get_obm("project")
)
}
\arguments{
\item{scope}{A supported obm scope, e.g. get_data, get_form_list, get_tables}

\item{control_condition}{Control condition.
- In API v3: 'limit=LIMIT:OFFSET' format
- In API v2: SQL-like, e.g., 'limit=10:1'}

\item{condition}{list - A condition based on column in your table.
- In API v3 (GraphQL): Can include operators like `iequals`, `AND`, `OR`, and special keys:
  - `fields`: vector of columns to return
  - `schema`: database schema (defaults to 'public')
  - `table`: database table (defaults to project name)
- In API v2: Mostly key-value pairs, e.g., list(species = 'Parus palustris')}

\item{table}{optional table from project (fallback if not in condition list)}
}
\value{
a data.frame, list or error message
}
\description{
This function get data or information from a project.
Supported functions (APIv3): 
  get_data: Get records from an SQL table or view, 
  get_public_data: Get publicly available records from an SQL table or view, 
  get_tables: Get list of SQL tables (or column list) and VIEWS in a project, 
  get_form_list, get_form_data: Get upload form information
For API v3 (api_version >= 3.0), 'get_data' uses GraphQL for powerful filtering and data selection.
See the [GraphQL User Guide](https://gitlab.com/openbiomaps/api/obm-project-api/-/blob/main/GraphQLUserGuide.md) for more details on query possibilities.
}
\details{
The following code *illustrates* how you could use this function in practice,
but it is **not meant to be run directly** (e.g., depends on external data).

# --- API v3 GraphQL Examples ---
\preformatted{
# get rows where column 'species' is 'Parus palustris' (case-insensitive)
data <- obm_get('get_data', condition=list(species = list(iequals = 'Parus palustris')))

# get specific fields from a specific table and schema
data <- obm_get('get_data',
                condition=list(
                  schema = "public",
                  table = "dead_animals",
                  fields = c("obm_id", "faj", "hely"),
                  faj = list(iequals = "asio otus")
                ))

# get all fields from the default table
data <- obm_get('get_data', 
                condition=list(
                  fields = '*',
                  faj = list(iequals = "asio otus")
                ))

# get 100 rows with offset 0
data <- obm_get('get_data', 'limit=100:0')

# get list of available forms
data <- obm_get('get_form_list')

# get list of available tables in the project
obm_get('get_tables')

# get table details (columns) in v3
obm_get('get_tables', condition=list(schema="public", table="dead_animals"))
}

# --- API v2 Examples ---
\preformatted{
results <- obm_get('get_form_list')

form <- obm_get('get_form_data',results[,]$published_form_id)

# get data rows from the main table from 39980 to 39988
data <- obm_get('get_data',condition=list(obm_id = '39980:39988'))

#get rows from the main table where column 'species' is 'Parus palustris'
data <- obm_get('get_data',condition=list(species = 'Parus palustris'))

#get 100 rows only from filtered query
data <- obm_get('get_data','limit=100:0',condition=list(species = 'Parus palustris'))

#get all data from the default/main table
data <- obm_get('get_data','*')

#get data from a non-default table
data <- obm_get('get_data','*',table='additional_data')
}
}
\examples{
\donttest{
data <- obm_get('get_data', condition=list(species = list(iequals = 'Parus palustris')))
}

}
\keyword{data}
\keyword{fetch}
\keyword{get}
