% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_logicalish.R
\name{is_logicalish}
\alias{is_logicalish}
\title{Check if an object is logical or numeric with only 0s and 1s}
\usage{
is_logicalish(x)
}
\arguments{
\item{x}{An R object to check.}
}
\value{
A logical value indicating whether \code{x} is logical or numeric
containing only 0s and 1s.
}
\description{
Check if an object is logical or numeric with only 0s and 1s
}
\examples{
is_logicalish(c(TRUE, FALSE, NA))        # returns TRUE
is_logicalish(c(0, 1, 1, 0, NA))         # returns TRUE
is_logicalish(c(0.0, 1.0, NA))           # returns TRUE
is_logicalish(c(0, 0.5, 1))              # returns FALSE
is_logicalish("TRUE")                    # returns FALSE
}
\author{
Michal Burda
}
