print.np.aov.test <-
  function(x, digits = 4, n = 10, ...){
    
    univar <- is.null(x$univariate)
    statletter <- ifelse(x$median.test, "H =",
                         ifelse(x$var.equal, "F =", "W ="))
    statistic <- paste(statletter, round(x$statistic, digits))
    p.value <- round(x$p.value, digits)
    
    # print info
    if(univar){
      cat("\n", x$method, "\n", sep = "")
    } else {
      cat("\n", "Multivariate ", x$method, "\n", sep = "")
    }
    if(is.null(x$nblocks)){
      cat("Number of Groups:", x$ngroups, "\n")
    } else {
      cat("Number of Groups:", x$ngroups, "    Number of Blocks:", x$nblocks, "\n")
    }
    cat(statistic, ",  p-value = ", p.value, "\n", sep = "")
    cat("\n")
    
  }