% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_lite_struct.R
\name{geo_lite_struct}
\alias{geo_lite_struct}
\title{Address search API (structured query)}
\usage{
geo_lite_struct(
  amenity = NULL,
  street = NULL,
  city = NULL,
  county = NULL,
  state = NULL,
  country = NULL,
  postalcode = NULL,
  lat = "lat",
  long = "lon",
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  nominatim_server = "https://nominatim.openstreetmap.org/",
  custom_query = list()
)
}
\arguments{
\item{amenity}{Name and/or type of POI, see also \link{geo_amenity}.}

\item{street}{House number and street name.}

\item{city}{City.}

\item{county}{County.}

\item{state}{State.}

\item{country}{Country.}

\item{postalcode}{Postal Code.}

\item{lat}{Latitude column name in the output data (default  \code{"lat"}).}

\item{long}{Longitude column name in the output data (default  \code{"long"}).}

\item{limit}{Maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{Returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_addresses}{Return input addresses with results if \code{TRUE}.}

\item{verbose}{If \code{TRUE} then detailed logs are output to the console.}

\item{nominatim_server}{The URL of the Nominatim server to use.
Defaults to \code{"https://nominatim.openstreetmap.org/"}.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} with the results found by the query.
}
\description{
Geocodes addresses already split into components. This function returns the
\code{\link[tibble:tibble]{tibble}} associated with the query, see
\code{\link[=geo_lite_struct_sf]{geo_lite_struct_sf()}} for retrieving the data as a spatial object
(\code{\link[sf:sf]{sf}} format).

This function correspond to the \strong{structured query} search described in the
\href{https://nominatim.org/release-docs/develop/api/Search/}{API endpoint}. For
performing a free-form search use \code{\link[=geo_lite]{geo_lite()}}.
}
\details{
The structured form of the search query allows to look up up an address that
is already split into its components. Each parameter represents a field of
the address. All parameters are optional. You should only use the ones that
are relevant for the address you want to geocode.

See \url{https://nominatim.org/release-docs/latest/api/Search/} for additional
parameters to be passed to \code{custom_query}.
}
\examples{
\dontshow{if (nominatim_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
pl_mayor <- geo_lite_struct(
  street = "Plaza Mayor", country = "Spain",
  limit = 50, full_results = TRUE
)


dplyr::glimpse(pl_mayor)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geo_lite_struct_sf]{geo_lite_struct_sf()}}, \code{\link[tidygeocoder:geo]{tidygeocoder::geo()}}.

Geocoding:
\code{\link{geo_address_lookup}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite_struct_sf}()}
}
\concept{geocoding}
