% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPPKinits.R
\name{print.getPPKinits}
\alias{print.getPPKinits}
\title{Print method for \code{getPPKinits} objects}
\usage{
\method{print}{getPPKinits}(x, ...)
}
\arguments{
\item{x}{An object of class \code{getPPKinits} containing the initial parameter estimation results.
Expected components include:
\itemize{
\item \code{Recommended_initial_estimates}: A data frame with estimated values and selection methods.
\item \code{Parameter.descriptions}: A character vector explaining the meaning of each parameter.
\item \code{time.spent}: Time taken to compute the estimates.
}}

\item{...}{Additional arguments (for compatibility with the generic \code{print()}).}
}
\value{
Prints a formatted summary to the console.
}
\description{
Prints a summary of the results from the initial parameter estimation pipeline,
including recommended initial estimates, ETA variance estimates, and parameter descriptions.
It is the default S3 \code{print} method for objects of class \code{getPPKinits}.
}
\examples{
\donttest{
## Oral example
inits.out <- getPPKinits(Bolus_1CPT)
print(inits.out)
}

}
