% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_graphcal.R
\name{graphcal_iv}
\alias{graphcal_iv}
\title{Graphical calculation of clearance and volume of distribution (IV route)}
\usage{
graphcal_iv(dat, dose = 1, ...)
}
\arguments{
\item{dat}{A data frame containing TIME (time after dosing) and DV
(observed concentration).}

\item{dose}{Administered dose amount. Defaults to 1.}

\item{...}{Additional arguments passed to \code{force_find_lambdaz()}.}
}
\value{
A list containing graphical estimates of CL, Vd, lambda_z, and C0exp.
}
\description{
Estimates clearance (CL), volume of distribution (Vd), terminal slope
(lambdaz), and extrapolated concentration at time zero (C0exp) from
intravenous pharmacokinetic data using graphical methods.
}
\details{
Terminal slope (lambdaz) is estimated using \code{force_find_lambdaz()}, which
applies an automated phase selection strategy with fallback regression when
required.
}
\examples{
dat <- data.frame(TIME = c(0.5, 1, 2, 4, 6, 8, 10),
                  DV = c(12, 8, 5, 3, 2, 1.5, 1))
graphcal_iv(dat, dose = 100)

}
\seealso{
\code{\link{force_find_lambdaz}}
}
\author{
Zhonghui Huang
}
