% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.operator.R
\name{step_iiv_f}
\alias{step_iiv_f}
\title{Forward selection of IIV on structural parameters}
\usage{
step_iiv_f(
  dat,
  start.mod = NULL,
  search.space = "ivbase",
  no.cores = NULL,
  param_table = NULL,
  penalty.control = NULL,
  precomputed_results_file = NULL,
  filename = "test",
  foldername = NULL,
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{start.mod}{A named integer vector specifying the starting model
code. If NULL, a base model is generated using \code{base_model()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{penalty.control}{A list of penalty control parameters defined by
\code{penaltyControl()}, specifying penalty values used for model diagnostics
during fitness evaluation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{foldername}{Character string specifying the name of the folder to be
created in the current working directory to store intermediate results.
If NULL, a name is generated automatically.}

\item{.modEnv}{Optional environment for storing intermediate results
across model runs.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments passed to the model estimation
function.}
}
\value{
A list with three elements:
\itemize{
\item results_table: A data frame summarizing all models evaluated
during the forward selection process.
\item best_code: A named integer vector corresponding to the selected
model.
\item best_row: A one-row data frame containing the results of the
selected model.
}
}
\description{
Implements a forward selection procedure to assess the inclusion of
inter-individual variability on structural pharmacokinetic parameters.
}
\details{
The procedure begins with an initial model and proceeds iteratively.
At each step, candidate models are generated by adding exactly one
additional IIV (random-effect) term while keeping all other aspects of
the model unchanged. If any candidate improves the chosen fitness
criterion, the best-improving candidate becomes the new reference model
for the next iteration. The algorithm stops when no further improvement
is achieved.
The set of parameters eligible for IIV depends on the number of
compartments:
\itemize{
\item One-compartment models: clearance and central volume
\item Two-compartment models: clearance, central volume, peripheral
volume, and inter-compartmental clearance
\item Three-compartment models: clearance, central volume,
peripheral volumes, and inter-compartmental clearances
}
}
\examples{
\donttest{
  dat <- Bolus_2CPT[Bolus_2CPT$SD==1,]
  param_table <- initialize_param_table()
  param_table$init[param_table$Name == "lcl"] <- log(4)
  param_table$init[param_table$Name == "lvc2cmpt"] <- log(70)
  param_table$init[param_table$Name == "lvp2cmpt"] <- log(40)
  param_table$init[param_table$Name == "lq2cmpt"] <- log(4)
  penalty.control <- penaltyControl()
  penalty.control$penalty.terms <-
    c("rse", "theta", "covariance", "shrinkage", "omega")
  start.mod <- base_model("ivbase")
  start.mod["no.cmpt"] <- 2L
  step_iiv_f(
    dat = dat,
    start.mod = start.mod,
    search.space = "ivbase",
    param_table = param_table,
    filename = "step_eta_test",
    penalty.control = penalty.control,
    saem.control = nlmixr2est::saemControl(logLik = TRUE,nBurn=15,nEm=15)
  )
}

}
\seealso{
\code{\link{mod.run}}, \code{\link{base_model}}, \code{\link{penaltyControl}}
}
\author{
Zhonghui Huang
}
