% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nl_geocode.R
\name{nl_geocode}
\alias{nl_geocode}
\alias{nl_geocode_rd}
\alias{nl_geocode_df}
\title{Geocode adresses}
\usage{
nl_geocode(
  location,
  output = c("wgs84", "rd", "data.frame"),
  messaging = FALSE,
  type = "adres",
  ...,
  verbose = messaging
)

nl_geocode_rd(
  location,
  messaging = FALSE,
  type = "adres",
  ...,
  verbose = messaging
)

nl_geocode_df(
  location,
  messaging = FALSE,
  type = "adres",
  ...,
  verbose = messaging
)
}
\arguments{
\item{location}{string with location to be found}

\item{output}{Should the output be a \code{\link[=data.frame]{data.frame()}} or
\code{\link[sf:sf]{sf::sf()}} object in wgs84 or Rijksdriehoekstelsel format?}

\item{messaging}{Print the urls fired to the webserver (consistent with \code{ggmap::geocode})}

\item{type}{restrict the type of object that is returned from the service,
see details for possible types.}

\item{...}{will be passed to \code{\link[=nl_free]{nl_free()}}.}

\item{verbose}{identical to \code{messaging} (consistent with other nlgeoder
functions)}
}
\value{
The return type can be specified and can be of type "sf" or "data.frame",
depending on the value of \code{output}.
}
\description{
\code{nl_geocode} returns for a vector of addresses
the most probable object/location.
This function is more user friendly than the barebones webservices
(\code{\link[=nl_free]{nl_free()}}), and uses the same function signature as
\code{ggmap::geocode}.
}
\details{
\code{type} can be one or more of the following: "provincie", "gemeente"
, "woonplaats", "weg", "postcode", "adres", "perceel", "hectometerpaal",
"wijk", "buurt", "waterschapsgrens", "appartementsrecht".
}
\examples{
data("addresses")
r <- nl_geocode(addresses$Address, output = "data.frame")
r["weergavenaam"]
names(r)

# or if you have sf installed
if (requireNamespace("sf", quietly = TRUE)){
  r_sf <- nl_geocode(addresses$Address, output = "wgs84")
  print(r_sf)
}
}
