% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_nfl.R
\name{gt_nfl_cols_label}
\alias{gt_nfl_cols_label}
\title{Render Logos, Wordmarks, and Headshots in 'gt' Table Column Labels}
\usage{
gt_nfl_cols_label(
  gt_object,
  columns = gt::everything(),
  ...,
  height = 30,
  type = c("logo", "wordmark", "headshot")
)
}
\arguments{
\item{gt_object}{A table object that is created using the \code{\link[gt:gt]{gt::gt()}} function.}

\item{columns}{The columns for which the image translation should be applied.
Argument has no effect if \code{locations} is not \code{NULL}.}

\item{...}{Currently not in use}

\item{height}{The absolute height (px) of the image in the table cell.}

\item{type}{One of \code{"logo"}, \code{"wordmark"}, or \code{"headshot"} selecting whether
to render a team's logo or wordmark image, or a player's headshot.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Translate NFL team abbreviations into logos and wordmarks or
NFL player gsis IDs to player headshots and render these images in
column labels of 'gt' tables.
}
\section{Output of below example}{

\if{html}{\figure{cols_label.png}{options: width=75\%}}
}

\examples{
\donttest{
library(gt)
label_df <- data.frame(
  "00-0036355" = 1,
  "00-0033873" = 2,
  "LAC" = 11,
  "KC" = 12,
  check.names = FALSE
)

# create gt table and translate player IDs and team abbreviations
# into headshots, logos, and wordmarks
table <- gt::gt(label_df) |>
  nflplotR::gt_nfl_cols_label(
    columns = gt::starts_with("00"),
    type = "headshot"
  ) |>
  nflplotR::gt_nfl_cols_label("LAC", type = "wordmark") |>
  nflplotR::gt_nfl_cols_label("KC", type = "logo")
}
}
\seealso{
The article that describes how nflplotR works with the 'gt' package
\url{https://nflplotr.nflverse.com/articles/gt.html}

The logo and wordmark rendering functions \code{\link[=gt_nfl_logos]{gt_nfl_logos()}} and
\code{\link[=gt_nfl_wordmarks]{gt_nfl_wordmarks()}}.

The player headshot rendering function \code{\link[=gt_nfl_headshots]{gt_nfl_headshots()}}.
}
