% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty_estimation.R
\name{.mc_dropout_forward}
\alias{.mc_dropout_forward}
\title{Internal helper: MC Dropout forward sampling}
\usage{
.mc_dropout_forward(model, x, passes, output_dim)
}
\arguments{
\item{model}{Fitted Keras model for one smooth term.}

\item{x}{Input matrix (converted to TensorFlow tensor internally).}

\item{passes}{Number of stochastic passes (>=2).}

\item{output_dim}{Expected number of outputs per observation
(e.g., 1 = mean only, 3 = quantile heads (lwr, upr, mean)).}
}
\value{
A numeric array of shape \code{[passes, n_obs, output_dim]}.
}
\description{
Run \code{passes} stochastic forward passes with Dropout active at prediction time.
Each pass samples a dropout mask and produces predictions, simulating epistemic
uncertainty.
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
\keyword{internal}
