% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_selection.R
\name{var_selection}
\alias{var_selection}
\title{network Structural Equation Modeling (netSEM)}
\usage{
var_selection(a, exogenous, endogenous)
}
\arguments{
\item{a}{A dataframe. By default it considers all columns as exogenous variables, except the first column which stores the system's endogenous variable.}

\item{exogenous, }{by default it considers all columns as exogenous variables except column number 1, which is the main endogenous response.}

\item{endogenous}{A character string of the column name of the main endogenous OR a numeric number indexing the column of the main endogenous.}
}
\value{
A character string of the variable that best represents a specific degradation mechanism.
}
\description{
This function selects the variable that best represents a specific degradation mechanism with the greatest adjusted R^2 of <S|M|.
}
\examples{
\dontrun{
## Load the sample acrylic data set
data(acrylic)

## Run netSEMp1_predict
ans <- var_selection(a = acrylic, exogenous = "IrradTot", endogenous = "YI")
}
}
