% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers.R
\name{npercent}
\alias{npercent}
\title{neat representation of percentage}
\usage{
npercent(
  percent,
  is_ratio = TRUE,
  digits = 1,
  show_plus_sign = TRUE,
  show_growth_factor = FALSE,
  show_bps = FALSE,
  is_decimal = NULL,
  plus_sign = NULL,
  factor_out = NULL,
  basis_points_out = NULL
)
}
\arguments{
\item{percent}{an integer or double representing percentage}

\item{is_ratio}{a Boolean variable. If the percent is raw,
the value to set as TRUE. See examples below.
If the percent variable is already pre-multiplied by 100
then the value to be set as FALSE.}

\item{digits}{number of digits to round-off}

\item{show_plus_sign}{a Boolean variable. If the percent is positive
then setting show_plus_sign = TRUE, includes an explicit + sign before the
percent}

\item{show_growth_factor}{an optional Boolean variable.}

\item{show_bps}{an optional parameter to get the percentage as basis points
If the percent exceeds |100%| then a string representing growth or drop as
readable factors. See examples below.}

\item{is_decimal}{Deprecated. Use 'is_ratio' instead.}

\item{plus_sign}{Deprecated. Use 'show_plus_sign' instead.}

\item{factor_out}{Deprecated. Use 'show_growth_factor' instead.}

\item{basis_points_out}{Deprecated. Use 'show_bps' instead.}
}
\value{
String representation of the percentages.
}
\description{
neat representation of percentage
}
\examples{
# Formatting 22.3\%
npercent(0.223, is_ratio = TRUE, digits = 1)
npercent(22.3, is_ratio = FALSE, digits = 1)
# Formatting percentages with growth factors
npercent(c(-4.01, 2.56), is_ratio = TRUE, show_growth_factor = TRUE)
# Formatting percentages as basis points
npercent(
  c(-1, -0.5, -0.1, -0.01, 0, 0.01, 0.1, 0.5, 1),
  is_ratio = TRUE, show_bps = TRUE
)
}
