% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{handler_redirect}
\alias{handler_redirect}
\title{Create HTTP Redirect Handler}
\usage{
handler_redirect(path, location, status = 302L, prefix = FALSE)
}
\arguments{
\item{path}{URI path to match (e.g., "/old-page").}

\item{location}{URL to redirect to. Can be relative (e.g., "/new-page") or
absolute (e.g., "https://example.com/page").}

\item{status}{HTTP redirect status code. Must be one of:
\itemize{
\item 301 - Moved Permanently
\item 302 - Found (default)
\item 303 - See Other
\item 307 - Temporary Redirect
\item 308 - Permanent Redirect
}}

\item{prefix}{[default FALSE] Logical, if TRUE matches path as a prefix.}
}
\value{
A handler object for use with \code{\link[=http_server]{http_server()}}.
}
\description{
Creates an HTTP handler that returns a redirect response.
}
\examples{
# Permanent redirect
h1 <- handler_redirect("/old", "/new", status = 301L)

# Redirect bare path to trailing slash
h2 <- handler_redirect("/app", "/app/")

}
