% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_learners.R
\name{compare_learners}
\alias{compare_learners}
\title{Compare Learners}
\usage{
compare_learners(sl_output, y_variable = NULL, loss_metric)
}
\arguments{
\item{sl_output}{Output from running \code{super_learner()} with \code{verbose_output = TRUE}.}

\item{y_variable}{A character vector indicating the outcome variable.
\code{y_variable} will be automatically inferred if it is missing and can
be inferred from the \code{sl_output}.}

\item{loss_metric}{A loss metric, like the mean-squared-error or negative-log-loss to be
used in comparing the learners. A loss metric should take two (vector) arguments:
predictions, and true outcomes, and produce a single statistic summarizing the
performance of each learner.}
}
\value{
A data.frame with the loss-metric on the held-out data for each learner.
}
\description{
Compare learners using the specified \code{loss_metric}
}
\examples{
sl_model <- super_learner(
  data = mtcars,
  learners = list(lm = lnr_lm, rf = lnr_rf, mean = lnr_mean),
  formula = mpg ~ .)

compare_learners(sl_model)

sl_model <- super_learner(
  data = mtcars,
  learners = list(lnr_logistic, lnr_rf_binary, mean = lnr_mean),
  formula = am ~ mpg,
  outcome_type = 'binary')
compare_learners(sl_model)

}
